/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.near;

import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.NearCacheMode;
import org.infinispan.client.hotrod.impl.InvalidatedNearRemoteCache;
import org.infinispan.client.hotrod.near.AssertsNearCache;
import org.infinispan.client.hotrod.near.MockNearCacheService;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.client.hotrod.test.SingleHotRodServerTest;
import org.infinispan.commons.util.BloomFilter;
import org.infinispan.commons.util.MurmurHash3BloomFilter;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.concurrent.CompletionStages;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.near.InvalidatedNearCacheBloomTest")
public class InvalidatedNearCacheBloomTest
extends SingleHotRodServerTest {
    private static final int NEAR_CACHE_SIZE = 4;
    private StorageType storageType;
    private AssertsNearCache<Integer, String> assertClient;
    private final BloomFilter<byte[]> bloomFilter = MurmurHash3BloomFilter.createFilter((int)16);

    private InvalidatedNearCacheBloomTest storageType(StorageType storageType) {
        this.storageType = storageType;
        return this;
    }

    @Factory
    public Object[] factory() {
        return new Object[]{new InvalidatedNearCacheBloomTest().storageType(StorageType.OBJECT), new InvalidatedNearCacheBloomTest().storageType(StorageType.BINARY), new InvalidatedNearCacheBloomTest().storageType(StorageType.OFF_HEAP)};
    }

    @BeforeMethod
    void beforeMethod() {
        this.assertClient.expectNoNearEvents();
        this.bloomFilter.addToFilter((Object)this.assertClient.remote.keyToBytes((Object)1));
    }

    @AfterMethod
    void resetBloomFilter() throws InterruptedException {
        this.assertClient.expectNoNearEvents(50L, TimeUnit.MILLISECONDS);
        ((InvalidatedNearRemoteCache)this.assertClient.remote).clearNearCache();
        CompletionStages.join((CompletionStage)((InvalidatedNearRemoteCache)this.assertClient.remote).updateBloomFilter());
        this.assertClient.events.clear();
    }

    protected String parameters() {
        return "[storageType-" + String.valueOf(this.storageType) + "]";
    }

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        org.infinispan.configuration.cache.ConfigurationBuilder cb = HotRodTestingUtil.hotRodCacheConfiguration();
        cb.memory().storageType(this.storageType);
        return TestCacheManagerFactory.createCacheManager((org.infinispan.configuration.cache.ConfigurationBuilder)cb);
    }

    @Override
    protected RemoteCacheManager getRemoteCacheManager() {
        this.assertClient = this.createAssertClient();
        return this.assertClient.manager;
    }

    private <K, V> AssertsNearCache<K, V> createAssertClient() {
        ConfigurationBuilder builder = this.clientConfiguration();
        builder.connectionPool().maxActive(1);
        return AssertsNearCache.create(this.cache(), builder);
    }

    private ConfigurationBuilder clientConfiguration() {
        ConfigurationBuilder builder = HotRodClientTestingUtil.newRemoteConfigurationBuilder();
        builder.addServer().host("127.0.0.1").port(this.hotrodServer.getPort().intValue());
        builder.nearCache().mode(NearCacheMode.INVALIDATED).maxEntries(4).bloomFilter(true);
        return builder;
    }

    public void testSingleKeyFilter() {
        this.assertClient.put(1, "v1").expectNearPreemptiveRemove(1);
        this.assertClient.put(1, "v2").expectNearPreemptiveRemove(1);
        this.assertClient.get(1, "v2").expectNearGetMissWithValue(1, "v2");
        this.assertClient.get(1, "v2").expectNearGetValue(1, "v2");
        this.assertClient.remove(1).expectNearRemove(1, new AssertsNearCache[0]);
        this.assertClient.get(1, null).expectNearGetMiss(1);
    }

    public void testMultipleKeyFilterConflictButNoRead() {
        this.assertClient.put(1, "v1").expectNearPreemptiveRemove(1);
        int conflictKey = this.findNextKey(this.bloomFilter, 1, true);
        this.assertClient.put(conflictKey, "v1").expectNearPreemptiveRemove(conflictKey);
        this.assertClient.put(conflictKey, "v2").expectNearPreemptiveRemove(conflictKey);
    }

    public void testMultipleKeyFilterConflict() {
        this.assertClient.put(1, "v1").expectNearPreemptiveRemove(1);
        this.assertClient.get(1, "v1").expectNearGetMissWithValue(1, "v1");
        int conflictKey = this.findNextKey(this.bloomFilter, 1, true);
        this.assertClient.put(conflictKey, "v1").expectNearPreemptiveRemove(conflictKey);
        this.assertClient.put(conflictKey, "v2").expectNearRemove(conflictKey, new AssertsNearCache[0]);
        this.assertClient.get(1, "v1").expectNearGetValue(1, "v1");
    }

    public void testMultipleKeyFilterNoConflict() {
        this.assertClient.put(1, "v1").expectNearPreemptiveRemove(1);
        this.assertClient.get(1, "v1").expectNearGetMissWithValue(1, "v1");
        int nonConflictKey = this.findNextKey(this.bloomFilter, 1, false);
        this.assertClient.put(nonConflictKey, "v1").expectNearPreemptiveRemove(nonConflictKey);
        this.assertClient.put(nonConflictKey, "v2").expectNearPreemptiveRemove(nonConflictKey);
    }

    public void testServerBloomFilterUpdate() throws InterruptedException {
        this.assertClient.put(1, "v1").expectNearPreemptiveRemove(1);
        this.assertClient.get(1, "v1").expectNearGetMissWithValue(1, "v1");
        int nonConflictKey = this.findNextKey(this.bloomFilter, 1, false);
        this.assertClient.put(nonConflictKey, "v1").expectNearPreemptiveRemove(nonConflictKey);
        this.assertClient.get(nonConflictKey, "v1").expectNearGetMissWithValue(nonConflictKey, "v1");
        boolean serverBloomFilterUpdated = false;
        for (int i = 0; i < 10; ++i) {
            this.assertClient.put(nonConflictKey, "v1");
            MockNearCacheService.MockEvent event = this.assertClient.events.poll(10L, TimeUnit.SECONDS);
            AssertJUnit.assertNotNull((Object)event);
            AssertJUnit.assertTrue((boolean)(event instanceof MockNearCacheService.MockRemoveEvent));
            AssertJUnit.assertEquals((Object)nonConflictKey, ((MockNearCacheService.MockRemoveEvent)event).key);
            event = this.assertClient.events.poll(100L, TimeUnit.MILLISECONDS);
            if (event == null) {
                serverBloomFilterUpdated = true;
                break;
            }
            AssertJUnit.assertTrue((boolean)(event instanceof MockNearCacheService.MockRemoveEvent));
            AssertJUnit.assertEquals((Object)nonConflictKey, ((MockNearCacheService.MockRemoveEvent)event).key);
            Thread.sleep(10L);
        }
        AssertJUnit.assertTrue((String)"The server bloom filter was never updated and we got remove events every time", (boolean)serverBloomFilterUpdated);
    }

    int findNextKey(BloomFilter<byte[]> filter, int originalValue, boolean present) {
        byte[] testKey;
        while (present != filter.possiblyPresent((Object)(testKey = this.assertClient.remote.keyToBytes((Object)(++originalValue))))) {
        }
        return originalValue;
    }
}

