/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.near;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.NearCacheMode;
import org.infinispan.client.hotrod.test.SingleHotRodServerTest;
import org.infinispan.container.impl.InternalDataContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.Mocks;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CheckPoint;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.mockito.Mockito;
import org.testng.AssertJUnit;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;

@Test(groups={"functional", "smoke"}, testName="client.hotrod.near.InvalidationNearCacheConcurrencyTest")
public class InvalidationNearCacheConcurrencyTest
extends SingleHotRodServerTest {
    private static final String CACHE_NAME = InvalidationNearCacheConcurrencyTest.class.getName();
    private boolean bloomFilter;

    InvalidationNearCacheConcurrencyTest bloomFilter(boolean enabled) {
        this.bloomFilter = enabled;
        return this;
    }

    @Factory
    public Object[] factory() {
        return new Object[]{new InvalidationNearCacheConcurrencyTest().bloomFilter(true), new InvalidationNearCacheConcurrencyTest().bloomFilter(false)};
    }

    protected String parameters() {
        return "[bloomFilter = " + this.bloomFilter + "]";
    }

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        org.infinispan.configuration.cache.ConfigurationBuilder cb = HotRodTestingUtil.hotRodCacheConfiguration();
        EmbeddedCacheManager manager = TestCacheManagerFactory.createCacheManager((org.infinispan.configuration.cache.ConfigurationBuilder)cb);
        manager.createCache(CACHE_NAME, cb.build());
        return manager;
    }

    @Override
    protected ConfigurationBuilder createHotRodClientConfigurationBuilder(String host, int port) {
        ConfigurationBuilder builder = super.createHotRodClientConfigurationBuilder(host, port);
        builder.remoteCache(CACHE_NAME).nearCacheMode(NearCacheMode.INVALIDATED).nearCacheUseBloomFilter(this.bloomFilter).nearCacheMaxEntries(100);
        return builder;
    }

    public void testConcurrentInvalidationWithRetrieval() throws InterruptedException, TimeoutException, ExecutionException {
        RemoteCache remoteCache = this.remoteCacheManager.getCache(CACHE_NAME);
        remoteCache.put((Object)1, (Object)"foo");
        Cache cache = this.cacheManager.getCache(CACHE_NAME);
        CheckPoint checkPoint = new CheckPoint();
        checkPoint.triggerForever("before_release");
        InternalDataContainer realContainer = (InternalDataContainer)Mocks.blockingMock((CheckPoint)checkPoint, InternalDataContainer.class, (Cache)cache, (stub, m) -> ((InternalDataContainer)stub.when(m)).peek(Mockito.anyInt(), Mockito.any()), (Class[])new Class[0]);
        Future future = this.fork(() -> AssertJUnit.assertEquals((String)((String)remoteCache.get((Object)1)), (String)"foo"));
        checkPoint.awaitStrict("after_invocation", 10L, TimeUnit.SECONDS);
        TestingUtil.replaceComponent((Cache)cache, InternalDataContainer.class, (Object)realContainer, (boolean)true);
        cache.keySet().forEach(arg_0 -> ((Cache)cache).remove(arg_0));
        checkPoint.trigger("after_release");
        future.get(10L, TimeUnit.SECONDS);
        AssertJUnit.assertEquals((int)0, (int)cache.size());
        this.eventuallyEquals(null, () -> (String)remoteCache.get((Object)1));
    }
}

