/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.near;

import java.util.Map;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.NearCacheMode;
import org.infinispan.client.hotrod.test.SingleHotRodServerTest;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.marshall.JavaSerializationMarshaller;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.ProtoStreamMarshaller;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.jboss.marshalling.commons.GenericJBossMarshaller;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.near.NearCacheMarshallingTest")
public class NearCacheMarshallingTest
extends SingleHotRodServerTest {
    private static final String SERVER_DEFINED_CACHE = "other-cache";
    private final Class<? extends Marshaller> marshaller;
    private final MediaType storeType;
    private final boolean useBloomFilter;

    protected NearCacheMarshallingTest(Class<? extends Marshaller> marshaller, MediaType storeType, boolean useBloomFilter) {
        this.marshaller = marshaller;
        this.storeType = storeType;
        this.useBloomFilter = useBloomFilter;
    }

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        org.infinispan.configuration.cache.ConfigurationBuilder serverCfg = new org.infinispan.configuration.cache.ConfigurationBuilder();
        if (this.storeType != null) {
            HotRodTestingUtil.hotRodCacheConfiguration((org.infinispan.configuration.cache.ConfigurationBuilder)serverCfg, (MediaType)this.storeType);
        }
        EmbeddedCacheManager ecm = TestCacheManagerFactory.createCacheManager((SerializationContextInitializer)this.contextInitializer(), (org.infinispan.configuration.cache.ConfigurationBuilder)serverCfg);
        org.infinispan.configuration.cache.ConfigurationBuilder cb = new org.infinispan.configuration.cache.ConfigurationBuilder();
        cb.encoding().key().mediaType("application/octet-stream");
        cb.encoding().value().mediaType("application/octet-stream");
        TestingUtil.defineConfiguration((EmbeddedCacheManager)ecm, (String)SERVER_DEFINED_CACHE, (Configuration)cb.build());
        return ecm;
    }

    @Override
    protected void setup() throws Exception {
        this.cacheManager = this.createCacheManager();
        this.hotrodServer = this.createHotRodServer();
    }

    @Override
    protected RemoteCacheManager getRemoteCacheManager() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.addServer().host("127.0.0.1").port(this.hotrodServer.getPort().intValue());
        if (this.marshaller != null) {
            builder.marshaller(this.marshaller);
        }
        builder.nearCache().mode(NearCacheMode.INVALIDATED).maxEntries(100);
        builder.remoteCache("").nearCacheMode(NearCacheMode.INVALIDATED).nearCacheMaxEntries(2).nearCacheUseBloomFilter(this.useBloomFilter);
        builder.connectionPool().maxActive(1);
        return new RemoteCacheManager(builder.build());
    }

    public void testServerDefinedCache() {
        RemoteCacheManager cacheManager = this.getRemoteCacheManager();
        Assertions.assertThat((Map)cacheManager.getCache(SERVER_DEFINED_CACHE)).isNotNull();
        Assertions.assertThat((Map)cacheManager.getCache()).isNotNull();
        cacheManager.stop();
    }

    public void testRemoteWriteOnLocal() throws Exception {
        RemoteCacheManager cacheManager = this.getRemoteCacheManager();
        RemoteCacheManager cacheManager1 = this.getRemoteCacheManager();
        RemoteCache cache = cacheManager.getCache();
        cache.put((Object)"K", (Object)"V");
        Assertions.assertThat((String)((String)cache.get((Object)"K"))).isEqualTo("V");
        RemoteCache cache1 = cacheManager1.getCache();
        Assertions.assertThat((String)((String)cache1.get((Object)"K"))).isEqualTo("V");
        cache1.replace((Object)"K", (Object)"V1");
        Assertions.assertThat((String)((String)cache1.get((Object)"K"))).isEqualTo("V1");
        NearCacheMarshallingTest.eventually(() -> ((String)cache.get((Object)"K")).equals("V1"));
        cacheManager.stop();
        cacheManager1.stop();
    }

    @Factory
    protected static Object[] testInstances() {
        return Stream.of(true, false).flatMap(useBloomFilter -> Stream.of(new NearCacheMarshallingTest(null, null, (boolean)useBloomFilter), new NearCacheMarshallingTest((Class<? extends Marshaller>)GenericJBossMarshaller.class, MediaType.APPLICATION_JBOSS_MARSHALLING, (boolean)useBloomFilter), new NearCacheMarshallingTest((Class<? extends Marshaller>)ProtoStreamMarshaller.class, MediaType.APPLICATION_PROTOSTREAM, (boolean)useBloomFilter), new NearCacheMarshallingTest((Class<? extends Marshaller>)ProtoStreamMarshaller.class, null, (boolean)useBloomFilter), new NearCacheMarshallingTest((Class<? extends Marshaller>)GenericJBossMarshaller.class, null, (boolean)useBloomFilter), new NearCacheMarshallingTest((Class<? extends Marshaller>)JavaSerializationMarshaller.class, null, (boolean)useBloomFilter))).toArray();
    }

    protected String parameters() {
        return String.format("(marshaller=%s, mediaType=%s, bloomFilter=%b", this.marshaller != null ? this.marshaller.getSimpleName() : "null", this.storeType, this.useBloomFilter);
    }
}

