/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.query;

import org.infinispan.Cache;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheContainer;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.marshall.MarshallerUtil;
import org.infinispan.client.hotrod.query.TestEntitySCIImpl;
import org.infinispan.client.hotrod.query.testdomain.protobuf.TestEntity;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.client.hotrod.test.InternalRemoteCacheManager;
import org.infinispan.client.hotrod.test.SingleHotRodServerTest;
import org.infinispan.commons.api.BasicCache;
import org.infinispan.configuration.cache.IndexStorage;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.GeneratedSchema;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.annotations.AutoProtoSchemaBuilder;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.query.BuiltInAnalyzersTest")
public class BuiltInAnalyzersTest
extends SingleHotRodServerTest {
    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        org.infinispan.configuration.cache.ConfigurationBuilder builder = new org.infinispan.configuration.cache.ConfigurationBuilder();
        builder.indexing().enable().storage(IndexStorage.LOCAL_HEAP).addIndexedEntity("TestEntity");
        EmbeddedCacheManager manager = TestCacheManagerFactory.createServerModeCacheManager();
        Cache metadataCache = manager.getCache("___protobuf_metadata");
        metadataCache.put((Object)"analyzers.proto", (Object)TestEntitySCI.INSTANCE.getProtoFile());
        HotRodClientTestingUtil.checkSchemaErrors((BasicCache<String, String>)metadataCache);
        manager.defineConfiguration("test", builder.build());
        return manager;
    }

    @BeforeClass
    protected void registerProtobufSchema() throws Exception {
        SerializationContext serCtx = MarshallerUtil.getSerializationContext((RemoteCacheContainer)this.remoteCacheManager);
        TestEntitySCI.INSTANCE.registerSchema(serCtx);
        TestEntitySCI.INSTANCE.registerMarshallers(serCtx);
    }

    @Override
    protected RemoteCacheManager getRemoteCacheManager() {
        ConfigurationBuilder builder = HotRodClientTestingUtil.newRemoteConfigurationBuilder();
        builder.addServer().host("127.0.0.1").port(this.hotrodServer.getPort().intValue());
        return new InternalRemoteCacheManager(builder.build());
    }

    @Test
    public void testKeywordAnalyzer() {
        RemoteCache remoteCache = this.remoteCacheManager.getCache("test");
        TestEntity child = new TestEntity("name", "name", "name", "name-with-dashes", "name", "name", null);
        TestEntity parent = new TestEntity("name", "name", "name", "name-with-dashes", "name", "name", child);
        remoteCache.put((Object)1, (Object)parent);
        AssertJUnit.assertEquals((int)1, (int)remoteCache.query("From TestEntity where name4:'name-with-dashes'").execute().count().value());
        AssertJUnit.assertEquals((int)1, (int)remoteCache.query("From TestEntity p where p.child.name4:'name-with-dashes'").execute().count().value());
    }

    @Test
    public void testShippedAnalyzers() {
        RemoteCache remoteCache = this.remoteCacheManager.getCache("test");
        TestEntity testEntity = new TestEntity("Sarah-Jane Lee", "John McDougall", "James Connor", "Oswald Lee", "Jason Hawkings", "Gyorgy Constantinides");
        remoteCache.put((Object)1, (Object)testEntity);
        AssertJUnit.assertEquals((int)1, (int)remoteCache.query("From TestEntity where name1:'jane'").execute().count().value());
        AssertJUnit.assertEquals((int)1, (int)remoteCache.query("From TestEntity where name2:'McDougall'").execute().count().value());
        AssertJUnit.assertEquals((int)1, (int)remoteCache.query("From TestEntity where name3:'Connor'").execute().count().value());
        AssertJUnit.assertEquals((int)1, (int)remoteCache.query("From TestEntity where name4:'Oswald Lee'").execute().count().value());
        AssertJUnit.assertEquals((int)1, (int)remoteCache.query("From TestEntity where name5:'hawk'").execute().count().value());
        AssertJUnit.assertEquals((int)1, (int)remoteCache.query("From TestEntity where name6:'constan'").execute().count().value());
        AssertJUnit.assertEquals((int)0, (int)remoteCache.query("From TestEntity where name1:'sara'").execute().count().value());
        AssertJUnit.assertEquals((int)0, (int)remoteCache.query("From TestEntity where name2:'John McDougal'").execute().count().value());
        AssertJUnit.assertEquals((int)0, (int)remoteCache.query("From TestEntity where name3:'James-Connor'").execute().count().value());
        AssertJUnit.assertEquals((int)0, (int)remoteCache.query("From TestEntity where name4:'Oswald lee'").execute().count().value());
        AssertJUnit.assertEquals((int)0, (int)remoteCache.query("From TestEntity where name5:'json'").execute().count().value());
        AssertJUnit.assertEquals((int)0, (int)remoteCache.query("From TestEntity where name6:'Georje'").execute().count().value());
    }

    @AutoProtoSchemaBuilder(includeClasses={TestEntity.class}, schemaFileName="test.client.BuiltInAnalyzersTest.proto", schemaFilePath="proto/generated", service=false)
    public static interface TestEntitySCI
    extends GeneratedSchema {
        public static final GeneratedSchema INSTANCE = new TestEntitySCIImpl();
    }
}

