/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.query;

import java.util.List;
import org.infinispan.client.hotrod.DataFormat;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.query.HotRodQueryTest;
import org.infinispan.commons.api.query.Query;
import org.infinispan.commons.api.query.QueryResult;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.UTF8StringMarshaller;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(testName="client.hotrod.query.HotRodQueryIspnDirectoryTest", groups={"functional"})
public class HotRodQueryIspnDirectoryTest
extends HotRodQueryTest {
    public void testReadAsJSON() {
        DataFormat acceptJSON = DataFormat.builder().valueType(MediaType.APPLICATION_JSON).valueMarshaller((Marshaller)new UTF8StringMarshaller()).build();
        RemoteCache jsonCache = this.remoteCache.withDataFormat(acceptJSON);
        Json user1 = Json.read((String)((String)jsonCache.get((Object)1)));
        AssertJUnit.assertEquals((String)"Tom", (String)user1.at("name").asString());
        AssertJUnit.assertEquals((String)"Cat", (String)user1.at("surname").asString());
        Query query = jsonCache.query("FROM sample_bank_account.User WHERE name = :name");
        query.maxResults(10).startOffset(0L).setParameter("name", (Object)"Tom");
        QueryResult result = query.execute();
        List results = result.list();
        AssertJUnit.assertEquals((int)1, (int)query.execute().count().value());
        AssertJUnit.assertFalse((boolean)query.hasProjections());
        Json jsonNode = Json.read((String)((String)results.iterator().next()));
        AssertJUnit.assertEquals((String)"Tom", (String)jsonNode.at("name").asString());
        AssertJUnit.assertEquals((String)"Cat", (String)jsonNode.at("surname").asString());
        results = query.execute().list();
        AssertJUnit.assertEquals((int)1, (int)results.size());
    }
}

