/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.query;

import org.infinispan.api.annotations.indexing.Basic;
import org.infinispan.api.annotations.indexing.Indexed;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheContainer;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.RemoteCacheManagerAdmin;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.query.IndexedCacheNonIndexedEntityTestSCIImpl;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.commons.api.CacheContainerAdmin;
import org.infinispan.commons.configuration.BasicConfiguration;
import org.infinispan.commons.configuration.StringConfiguration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.GeneratedSchema;
import org.infinispan.protostream.annotations.AutoProtoSchemaBuilder;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoName;
import org.infinispan.server.core.admin.AdminOperationsHandler;
import org.infinispan.server.core.admin.embeddedserver.EmbeddedServerAdminOperationHandler;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.configuration.HotRodServerConfigurationBuilder;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test(testName="client.hotrod.query.IndexedCacheNonIndexedEntityTest", groups={"functional"})
public class IndexedCacheNonIndexedEntityTest
extends SingleCacheManagerTest {
    private static final String CACHE_NAME = "IndexedCacheNonIndexedEntitiesTest";
    protected HotRodServer hotRodServer;
    protected RemoteCacheManager remoteCacheManager;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        this.cacheManager = TestCacheManagerFactory.createCacheManager((org.infinispan.configuration.cache.ConfigurationBuilder)new org.infinispan.configuration.cache.ConfigurationBuilder());
        HotRodServerConfigurationBuilder serverBuilder = new HotRodServerConfigurationBuilder();
        serverBuilder.adminOperationsHandler((AdminOperationsHandler)new EmbeddedServerAdminOperationHandler());
        this.hotRodServer = HotRodClientTestingUtil.startHotRodServer(this.cacheManager, serverBuilder);
        ConfigurationBuilder clientBuilder = HotRodClientTestingUtil.newRemoteConfigurationBuilder();
        clientBuilder.addServer().host("127.0.0.1").port(this.hotRodServer.getPort().intValue());
        this.remoteCacheManager = new RemoteCacheManager(clientBuilder.build());
        HotRodClientTestingUtil.registerSCI(this.remoteCacheManager, IndexedCacheNonIndexedEntityTestSCI.INSTANCE);
        return this.cacheManager;
    }

    @AfterClass(alwaysRun=true)
    public void release() {
        HotRodClientTestingUtil.killRemoteCacheManager((RemoteCacheContainer)this.remoteCacheManager);
        HotRodClientTestingUtil.killServers(this.hotRodServer);
    }

    @Test(expectedExceptions={HotRodClientException.class}, expectedExceptionsMessageRegExp=".*The configured indexed-entity type 'Entity' must be indexed.*")
    public void shouldPreventNonIndexedEntities() {
        String config = "<infinispan>  <cache-container>     <local-cache name=\"IndexedCacheNonIndexedEntitiesTest\">\n        <encoding media-type=\"application/x-protostream\"/>\n        <indexing storage=\"local-heap\">\n           <indexed-entities>\n              <indexed-entity>Entity</indexed-entity>\n              <indexed-entity>EvilTwin</indexed-entity>\n           </indexed-entities>\n          </indexing>       </local-cache>  </cache-container></infinispan>";
        ((RemoteCacheManagerAdmin)this.remoteCacheManager.administration().withFlags(new CacheContainerAdmin.AdminFlag[]{CacheContainerAdmin.AdminFlag.VOLATILE})).createCache(CACHE_NAME, (BasicConfiguration)new StringConfiguration(config));
        RemoteCache cache = this.remoteCacheManager.getCache(CACHE_NAME);
        cache.put((Object)"1", (Object)new Entity("name"));
    }

    @AutoProtoSchemaBuilder(includeClasses={Entity.class, EvilTwin.class}, schemaFileName="test.client.IndexedCacheNonIndexedEntityTest.proto", schemaFilePath="proto/generated", service=false)
    public static interface IndexedCacheNonIndexedEntityTestSCI
    extends GeneratedSchema {
        public static final GeneratedSchema INSTANCE = new IndexedCacheNonIndexedEntityTestSCIImpl();
    }

    @ProtoName(value="Entity")
    static class Entity {
        private final String name;

        @ProtoFactory
        public Entity(String name) {
            this.name = name;
        }

        @ProtoField(value=1)
        public String getName() {
            return this.name;
        }
    }

    @Indexed
    @ProtoName(value="EvilTwin")
    static class EvilTwin {
        @Basic
        @ProtoField(value=1)
        public String name;

        EvilTwin() {
        }
    }
}

