/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.query;

import java.util.List;
import org.infinispan.api.annotations.indexing.Basic;
import org.infinispan.api.annotations.indexing.Indexed;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.Search;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.query.RemoteQueryWithProtostreamAnnotationsTestSCIImpl;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.client.hotrod.test.SingleHotRodServerTest;
import org.infinispan.configuration.cache.IndexStorage;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.GeneratedSchema;
import org.infinispan.protostream.annotations.AutoProtoSchemaBuilder;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoName;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(testName="client.hotrod.query.RemoteQueryWithProtostreamAnnotationsTest", groups={"functional"})
public class RemoteQueryWithProtostreamAnnotationsTest
extends SingleHotRodServerTest {
    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        org.infinispan.configuration.cache.ConfigurationBuilder builder = new org.infinispan.configuration.cache.ConfigurationBuilder();
        builder.indexing().enable().storage(IndexStorage.LOCAL_HEAP).addIndexedEntity("Memo");
        EmbeddedCacheManager manager = TestCacheManagerFactory.createServerModeCacheManager();
        manager.defineConfiguration("test", builder.build());
        return manager;
    }

    @Override
    protected RemoteCacheManager getRemoteCacheManager() {
        ConfigurationBuilder clientBuilder = HotRodClientTestingUtil.newRemoteConfigurationBuilder();
        clientBuilder.addServer().host("127.0.0.1").port(this.hotrodServer.getPort().intValue());
        RemoteCacheManager remoteCacheManager = new RemoteCacheManager(clientBuilder.build());
        HotRodClientTestingUtil.registerSCI(remoteCacheManager, RemoteQueryWithProtostreamAnnotationsTestSCI.INSTANCE);
        return remoteCacheManager;
    }

    public void testAttributeQuery() {
        RemoteCache remoteCache = this.remoteCacheManager.getCache("test");
        remoteCache.put((Object)1, (Object)this.createMemo1());
        remoteCache.put((Object)2, (Object)this.createMemo2());
        Memo fromCache = (Memo)remoteCache.get((Object)1);
        this.assertMemo1(fromCache);
        QueryFactory qf = Search.getQueryFactory((RemoteCache)remoteCache);
        Query query = qf.from(Memo.class).having("text").like("%ipsum%").build();
        List list = query.execute().list();
        AssertJUnit.assertNotNull((Object)list);
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals(Memo.class, ((Memo)list.get(0)).getClass());
        this.assertMemo1((Memo)list.get(0));
        query = qf.from(Memo.class).having("author.name").eq((Object)"Adrian").build();
        list = query.execute().list();
        AssertJUnit.assertNotNull((Object)list);
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals(Memo.class, ((Memo)list.get(0)).getClass());
        this.assertMemo2((Memo)list.get(0));
    }

    private Memo createMemo1() {
        Memo memo = new Memo(1, "Lorem ipsum");
        memo.setAuthor(new Author(1, "Tom"));
        return memo;
    }

    private Memo createMemo2() {
        Memo memo = new Memo(2, "Sed ut perspiciatis unde omnis iste natus error");
        memo.setAuthor(new Author(2, "Adrian"));
        return memo;
    }

    private void assertMemo1(Memo memo) {
        AssertJUnit.assertNotNull((Object)memo);
        AssertJUnit.assertEquals((int)1, (int)memo.getId());
        AssertJUnit.assertEquals((String)"Lorem ipsum", (String)memo.getText());
        AssertJUnit.assertEquals((int)1, (int)memo.getAuthor().getId());
    }

    private void assertMemo2(Memo memo) {
        AssertJUnit.assertNotNull((Object)memo);
        AssertJUnit.assertEquals((int)2, (int)memo.getId());
        AssertJUnit.assertEquals((String)"Sed ut perspiciatis unde omnis iste natus error", (String)memo.getText());
        AssertJUnit.assertEquals((int)2, (int)memo.getAuthor().getId());
    }

    @AutoProtoSchemaBuilder(includeClasses={Author.class, Memo.class}, schemaFileName="test.client.RemoteQueryWithProtostreamAnnotationsTest.proto", schemaFilePath="proto/generated", service=false)
    public static interface RemoteQueryWithProtostreamAnnotationsTestSCI
    extends GeneratedSchema {
        public static final GeneratedSchema INSTANCE = new RemoteQueryWithProtostreamAnnotationsTestSCIImpl();
    }

    @Indexed
    @ProtoName(value="Memo")
    public static class Memo {
        private int id;
        private String text;
        private Author author;

        public Memo(int id, String text) {
            this.id = id;
            this.text = text;
        }

        public Memo() {
        }

        @ProtoField(number=10, defaultValue="0")
        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        @Basic(projectable=true)
        @ProtoField(value=20)
        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        @Basic(projectable=true)
        @ProtoField(value=30)
        public Author getAuthor() {
            return this.author;
        }

        public void setAuthor(Author author) {
            this.author = author;
        }

        public String toString() {
            return "Memo{id=" + this.id + ", text='" + this.text + "', author=" + String.valueOf(this.author) + "}";
        }
    }

    @Indexed
    @ProtoName(value="Author")
    public static class Author {
        private int id;
        private String name;

        public Author(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public Author() {
        }

        @ProtoField(number=1, defaultValue="0")
        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        @Basic(projectable=true)
        @ProtoField(number=2)
        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String toString() {
            return "Author{id=" + this.id + ", name='" + this.name + "'}";
        }
    }
}

