/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.query;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.api.annotations.indexing.Indexed;
import org.infinispan.api.annotations.indexing.Text;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.query.ReplicationIndexTestSCIImpl;
import org.infinispan.client.hotrod.test.FixedServerBalancing;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.client.hotrod.test.InternalRemoteCacheManager;
import org.infinispan.client.hotrod.test.MultiHotRodServersTest;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.ProtoStreamMarshaller;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.IndexStorage;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.GeneratedSchema;
import org.infinispan.protostream.annotations.AutoProtoSchemaBuilder;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.server.hotrod.HotRodServer;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.query.ReplicationIndexTest")
public class ReplicationIndexTest
extends MultiHotRodServersTest {
    public static final String CACHE_NAME = "test-cache";
    public static final String PROTO_FILE = "file.proto";
    public static final int ENTRIES = 2;
    private final AtomicInteger serverCount = new AtomicInteger(0);

    protected void addNode() throws IOException {
        int index = this.serverCount.incrementAndGet();
        this.addHotRodServer(ReplicationIndexTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.REPL_SYNC));
        EmbeddedCacheManager cacheManager = this.manager(index - 1);
        RemoteCacheManager remoteCacheManager = this.createClient(index - 1);
        this.clients.add(remoteCacheManager);
        HotRodClientTestingUtil.registerSCI(remoteCacheManager, ReplicationIndexTestSCI.INSTANCE);
        org.infinispan.configuration.cache.ConfigurationBuilder builder = ReplicationIndexTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.REPL_SYNC, (boolean)this.isTransactional());
        builder.indexing().enable().storage(IndexStorage.LOCAL_HEAP).addIndexedEntity("Entity");
        cacheManager.defineConfiguration(CACHE_NAME, builder.build());
    }

    private void killLastNode() {
        int index = this.serverCount.decrementAndGet();
        ((RemoteCacheManager)this.clients.remove(index)).close();
        this.killServer(index);
    }

    protected boolean isTransactional() {
        return false;
    }

    @Override
    protected RemoteCacheManager createClient(int i) {
        HotRodServer server = this.server(i);
        ConfigurationBuilder clientBuilder = HotRodClientTestingUtil.newRemoteConfigurationBuilder();
        clientBuilder.addServer().host(server.getHost()).port(server.getPort().intValue()).marshaller((Marshaller)new ProtoStreamMarshaller()).balancingStrategy(() -> new FixedServerBalancing(server));
        return new InternalRemoteCacheManager(clientBuilder.build());
    }

    protected void createCacheManagers() throws Throwable {
        this.addNode();
    }

    private long queryCount(String query, RemoteCache<?, ?> remoteCache) {
        return remoteCache.query(query).execute().count().value();
    }

    @Test
    public void testIndexingDuringStateTransfer() throws IOException {
        RemoteCache remoteCache = ((RemoteCacheManager)this.clients.get(0)).getCache(CACHE_NAME);
        for (int i = 0; i < 2; ++i) {
            remoteCache.put((Object)i, (Object)Entity.create("name" + i));
        }
        this.assertIndexed(remoteCache);
        this.addNode();
        try {
            this.waitForClusterToForm(CACHE_NAME);
            RemoteCache secondRemoteCache = ((RemoteCacheManager)this.clients.get(1)).getCache(CACHE_NAME);
            this.assertIndexed(secondRemoteCache);
        }
        finally {
            this.killLastNode();
        }
    }

    private void assertIndexed(RemoteCache<?, ?> remoteCache) {
        AssertJUnit.assertEquals((int)2, (int)remoteCache.size());
        AssertJUnit.assertEquals((long)2L, (long)this.queryCount("FROM Entity", remoteCache));
        AssertJUnit.assertEquals((long)1L, (long)this.queryCount("FROM Entity where name:'name1'", remoteCache));
    }

    @AutoProtoSchemaBuilder(includeClasses={Entity.class}, schemaFileName="test.client.ReplicationIndexTest.proto", schemaFilePath="proto/generated", service=false)
    public static interface ReplicationIndexTestSCI
    extends GeneratedSchema {
        public static final GeneratedSchema INSTANCE = new ReplicationIndexTestSCIImpl();
    }

    @Indexed
    static class Entity {
        private String name;

        static Entity create(String name) {
            Entity entity = new Entity();
            entity.setName(name);
            return entity;
        }

        @Text
        @ProtoField(number=1)
        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

