/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.query.aggregation;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import org.assertj.core.api.Assertions;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.test.SingleHotRodServerTest;
import org.infinispan.commons.api.query.Query;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.IndexStorage;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.query.aggregation.QueryAggregationCountTest;
import org.infinispan.query.model.Sale;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="org.infinispan.client.hotrod.query.aggregation.RemoteQueryAggregationCountTest")
public class RemoteQueryAggregationCountTest
extends SingleHotRodServerTest {
    private final Random fixedSeedPseudoRandom = new Random(739L);

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder indexed = new ConfigurationBuilder();
        indexed.indexing().enable().storage(IndexStorage.LOCAL_HEAP).addIndexedEntity("Sale");
        return TestCacheManagerFactory.createServerModeCacheManager((ConfigurationBuilder)indexed);
    }

    @Override
    protected SerializationContextInitializer contextInitializer() {
        return Sale.SaleSchema.INSTANCE;
    }

    @Test
    public void test() {
        RemoteCache remoteCache = this.remoteCacheManager.getCache();
        for (int day = 1; day <= 10; ++day) {
            remoteCache.putAll((Map)QueryAggregationCountTest.chunk((int)day, (Random)this.fixedSeedPseudoRandom));
        }
        Query query = remoteCache.query("select status, count(code) from Sale where day = :day group by status order by status");
        query.setParameter("day", (Object)5);
        Assertions.assertThat((List)query.list()).containsExactly((Object[])QueryAggregationCountTest.AGGREGATION_RESULT);
        query = remoteCache.query("select count(code), status from Sale where day = :day group by status order by status");
        query.setParameter("day", (Object)5);
        Assertions.assertThat((List)query.list()).containsExactly((Object[])QueryAggregationCountTest.REV_AGGREGATION_RESULT);
        query = remoteCache.query("select status, count(code) from Sale where day = :day group by status");
        query.setParameter("day", (Object)5);
        Assertions.assertThat((List)query.list()).containsExactlyInAnyOrder((Object[])QueryAggregationCountTest.AGGREGATION_RESULT);
        query = remoteCache.query("select status, count(code) from Sale group by status");
        Optional<Integer> totalNotNullItems = query.list().stream().map(objects -> ((Long)objects[1]).intValue()).reduce(Integer::sum);
        Assertions.assertThat(totalNotNullItems).hasValue((Object)10000);
    }
}

