/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.query.legacy;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.Search;
import org.infinispan.client.hotrod.test.SingleHotRodServerTest;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.IndexStorage;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.dsl.QueryResult;
import org.infinispan.query.model.LegacyGame;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="org.infinispan.client.hotrod.query.legacy.RemoteHS5LegacyAnnotationsTest")
public class RemoteHS5LegacyAnnotationsTest
extends SingleHotRodServerTest {
    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder indexed = new ConfigurationBuilder();
        indexed.indexing().enable().storage(IndexStorage.LOCAL_HEAP).addIndexedEntity("LegacyGame");
        EmbeddedCacheManager manager = TestCacheManagerFactory.createServerModeCacheManager();
        manager.defineConfiguration("indexed-games", indexed.build());
        return manager;
    }

    @Override
    protected SerializationContextInitializer contextInitializer() {
        return LegacyGame.LegacyGameSchema.INSTANCE;
    }

    @Test
    public void test() {
        RemoteCache remoteCache = this.remoteCacheManager.getCache("indexed-games");
        remoteCache.put((Object)"a", (Object)new LegacyGame("Game A", "bla bla bla bli", Integer.valueOf(1999)));
        remoteCache.put((Object)"b", (Object)new LegacyGame("Game B", "bla bla bla uuu", Integer.valueOf(2013)));
        remoteCache.put((Object)"c", (Object)new LegacyGame("Game C", "bla aaa bla bli", Integer.valueOf(2000)));
        QueryFactory factory = Search.getQueryFactory((RemoteCache)remoteCache);
        Query queryNames = factory.create("select g.name from LegacyGame g where g.name : 'Game B'");
        QueryResult resultNames = queryNames.execute();
        Assertions.assertThat((boolean)resultNames.count().isExact()).isTrue();
        Assertions.assertThat((int)resultNames.count().value()).isEqualTo(1);
        Assertions.assertThat((List)resultNames.list()).containsExactly((Object[])new String[][]{{"Game B"}});
        Query queryGames = factory.create("from LegacyGame g where g.description : 'bli' order by g.releaseYear desc");
        QueryResult resultGames = queryGames.execute();
        Assertions.assertThat((boolean)resultGames.count().isExact()).isTrue();
        Assertions.assertThat((int)resultGames.count().value()).isEqualTo(2);
        Assertions.assertThat((List)resultGames.list()).extracting("name").containsExactly(new Object[]{"Game C", "Game A"});
    }
}

