/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.query.maxresult;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.test.SingleHotRodServerTest;
import org.infinispan.commons.api.query.Query;
import org.infinispan.commons.api.query.QueryResult;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.IndexStorage;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.query.model.Game;
import org.infinispan.query.model.NonIndexedGame;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="org.infinispan.client.hotrod.query.maxresult.RemoteDefaultMaxResultTest")
public class RemoteDefaultMaxResultTest
extends SingleHotRodServerTest {
    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder indexed = new ConfigurationBuilder();
        indexed.indexing().enable().storage(IndexStorage.LOCAL_HEAP).addIndexedEntity("Game");
        ConfigurationBuilder notIndexed = new ConfigurationBuilder();
        EmbeddedCacheManager manager = TestCacheManagerFactory.createServerModeCacheManager();
        manager.defineConfiguration("indexed-games", indexed.build());
        manager.defineConfiguration("not-indexed-games", notIndexed.build());
        return manager;
    }

    @Override
    protected SerializationContextInitializer contextInitializer() {
        return Game.GameSchema.INSTANCE;
    }

    @Test
    public void testNonIndexed() {
        RemoteCache games = this.remoteCacheManager.getCache("not-indexed-games");
        for (int i = 1; i <= 110; ++i) {
            games.put((Object)i, (Object)new NonIndexedGame("Game " + i, "This is the game " + i + "# of a series"));
        }
        Query query = games.query("from NonIndexedGame");
        QueryResult result = query.execute();
        Assertions.assertThat((int)result.count().value()).isEqualTo(110);
        Assertions.assertThat((List)result.list()).hasSize(100);
        query = games.query("from NonIndexedGame");
        query.maxResults(200);
        result = query.execute();
        Assertions.assertThat((int)result.count().value()).isEqualTo(110);
        Assertions.assertThat((List)result.list()).hasSize(110);
    }

    @Test
    public void testIndexed() {
        RemoteCache games = this.remoteCacheManager.getCache("indexed-games");
        for (int i = 1; i <= 110; ++i) {
            games.put((Object)i, (Object)new Game("Game " + i, "This is the game " + i + "# of a series"));
        }
        Query query = games.query("from Game");
        QueryResult result = query.execute();
        Assertions.assertThat((int)result.count().value()).isEqualTo(110);
        Assertions.assertThat((List)result.list()).hasSize(100);
        query = games.query("from Game");
        query.maxResults(200);
        result = query.execute();
        Assertions.assertThat((int)result.count().value()).isEqualTo(110);
        Assertions.assertThat((List)result.list()).hasSize(110);
    }
}

