/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.query.maxresult;

import org.assertj.core.api.Assertions;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.test.SingleHotRodServerTest;
import org.infinispan.commons.api.query.Query;
import org.infinispan.commons.api.query.QueryResult;
import org.infinispan.configuration.cache.IndexStorage;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.query.model.Game;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="org.infinispan.client.hotrod.query.maxresult.RemoteHitCountAccuracyTest")
public class RemoteHitCountAccuracyTest
extends SingleHotRodServerTest {
    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        org.infinispan.configuration.cache.ConfigurationBuilder indexed = new org.infinispan.configuration.cache.ConfigurationBuilder();
        indexed.indexing().enable().storage(IndexStorage.LOCAL_HEAP).addIndexedEntity("Game");
        indexed.query().hitCountAccuracy(10);
        EmbeddedCacheManager manager = TestCacheManagerFactory.createServerModeCacheManager();
        manager.defineConfiguration("indexed-games", indexed.build());
        return manager;
    }

    @Override
    protected SerializationContextInitializer contextInitializer() {
        return Game.GameSchema.INSTANCE;
    }

    @Override
    protected ConfigurationBuilder createHotRodClientConfigurationBuilder(String host, int serverPort) {
        return super.createHotRodClientConfigurationBuilder(host, serverPort).socketTimeout(60000).maxRetries(0);
    }

    @Test
    public void overrideHitCountAccuracy() {
        RemoteCache games = this.remoteCacheManager.getCache("indexed-games");
        for (int i = 1; i <= 5000; ++i) {
            games.put((Object)i, (Object)new Game("Game " + i, "This is the game " + i + "# of a series"));
        }
        Query query = games.query("from Game where description : 'game'");
        QueryResult result = query.execute();
        Assertions.assertThat((boolean)result.count().isExact()).isFalse();
        query = games.query("from Game where description : 'game'");
        query.hitCountAccuracy(5000);
        result = query.execute();
        Assertions.assertThat((boolean)result.count().isExact()).isTrue();
        Assertions.assertThat((int)result.count().value()).isEqualTo(5000);
    }
}

