/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.query.projection;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.infinispan.client.hotrod.MetadataValue;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.test.SingleHotRodServerTest;
import org.infinispan.commons.api.query.Query;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.IndexStorage;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.query.model.Developer;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="org.infinispan.client.hotrod.query.projection.MetaProjectionTest")
public class MetaProjectionTest
extends SingleHotRodServerTest {
    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder config = new ConfigurationBuilder();
        config.indexing().enable().storage(IndexStorage.LOCAL_HEAP).addIndexedEntity("io.dev.Developer");
        return TestCacheManagerFactory.createServerModeCacheManager((ConfigurationBuilder)config);
    }

    @Override
    protected SerializationContextInitializer contextInitializer() {
        return Developer.DeveloperSchema.INSTANCE;
    }

    @Test
    public void testVersionProjection() {
        RemoteCache remoteCache = this.remoteCacheManager.getCache();
        remoteCache.put((Object)"open-contributor", (Object)new Developer("iamopen", "iamopen@redmail.io", "Hibernate developer", Integer.valueOf(2000)));
        remoteCache.put((Object)"open-contributor", (Object)new Developer("iamopen", "iamopen@redmail.io", "Infinispan developer", Integer.valueOf(2000)));
        remoteCache.put((Object)"another-contributor", (Object)new Developer("mycodeisopen", "mycodeisopen@redmail.io", "Infinispan engineer", Integer.valueOf(799)));
        MetadataValue metadata = remoteCache.getWithMetadata((Object)"open-contributor");
        Assertions.assertThat((long)metadata.getVersion()).isEqualTo(2L);
        metadata = remoteCache.getWithMetadata((Object)"another-contributor");
        Assertions.assertThat((long)metadata.getVersion()).isEqualTo(3L);
        Query query = remoteCache.query("select d.nick, version(d), d.email, d.biography, d.contributions from io.dev.Developer d where d.biography : 'Infinispan' order by d.email");
        List list = query.execute().list();
        Assertions.assertThat((List)list).hasSize(2);
        Assertions.assertThat((Object[])((Object[])list.get(0))).containsExactly(new Object[]{"iamopen", 2L, "iamopen@redmail.io", "Infinispan developer", 2000});
        Assertions.assertThat((Object[])((Object[])list.get(1))).containsExactly(new Object[]{"mycodeisopen", 3L, "mycodeisopen@redmail.io", "Infinispan engineer", 799});
        query = remoteCache.query("select d, version(d) from io.dev.Developer d where d.biography : 'Infinispan' order by d.email");
        list = query.execute().list();
        Assertions.assertThat((List)list).hasSize(2);
        ((ObjectAssert)Assertions.assertThat((Object)((Object[])list.get(0))[0]).isNotNull()).isInstanceOf(Developer.class);
        Assertions.assertThat((Object)((Object[])list.get(0))[1]).isEqualTo((Object)2L);
        ((ObjectAssert)Assertions.assertThat((Object)((Object[])list.get(1))[0]).isNotNull()).isInstanceOf(Developer.class);
        Assertions.assertThat((Object)((Object[])list.get(1))[1]).isEqualTo((Object)3L);
    }
}

