/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.query.projection;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.test.SingleHotRodServerTest;
import org.infinispan.commons.api.query.Query;
import org.infinispan.commons.api.query.QueryResult;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.IndexStorage;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.query.model.Game;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="org.infinispan.client.hotrod.query.projection.RemoteProjectionTest")
public class RemoteProjectionTest
extends SingleHotRodServerTest {
    private static final int ENTRIES = 10;

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder indexed = new ConfigurationBuilder();
        indexed.indexing().enable().storage(IndexStorage.LOCAL_HEAP).addIndexedEntity("Game");
        return TestCacheManagerFactory.createServerModeCacheManager((ConfigurationBuilder)indexed);
    }

    @Override
    protected SerializationContextInitializer contextInitializer() {
        return Game.GameSchema.INSTANCE;
    }

    @Test
    public void test() {
        RemoteCache games = this.remoteCacheManager.getCache();
        for (int i = 1; i <= 10; ++i) {
            games.put((Object)("g" + i), (Object)new Game("bla" + i, "bla bla" + i));
        }
        Query query = games.query("select g.description from Game g where g.description : 'bla3'");
        QueryResult result = query.execute();
        Assertions.assertThat((List)result.list()).extracting(array -> array[0]).containsExactly(new Object[]{"bla bla3"});
        query = games.query("select g from Game g where g.description : 'bla3'");
        result = query.execute();
        Assertions.assertThat((List)result.list()).extracting(array -> array[0]).extracting("name").containsExactly(new Object[]{"bla3"});
        query = games.query("select g, g.description from Game g where g.description : 'bla3'");
        result = query.execute();
        Assertions.assertThat((List)result.list()).extracting(array -> array[0]).extracting("name").containsExactly(new Object[]{"bla3"});
        Assertions.assertThat((List)result.list()).extracting(array -> array[1]).containsExactly(new Object[]{"bla bla3"});
    }
}

