/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.query.schema;

import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.assertj.core.api.Assertions;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.query.testdomain.protobuf.Programmer;
import org.infinispan.client.hotrod.query.testdomain.protobuf.ProgrammerSchemaImpl;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.client.hotrod.test.SingleHotRodServerTest;
import org.infinispan.commons.api.query.Query;
import org.infinispan.commons.api.query.QueryResult;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.IndexStorage;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.objectfilter.impl.ProtobufMatcher;
import org.infinispan.objectfilter.impl.syntax.parser.IckleParsingResult;
import org.infinispan.objectfilter.impl.syntax.parser.ObjectPropertyHelper;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.protostream.descriptors.AnnotationElement;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.protostream.descriptors.FieldDescriptor;
import org.infinispan.protostream.impl.ResourceUtils;
import org.infinispan.query.core.impl.QueryCache;
import org.infinispan.server.core.admin.AdminOperationsHandler;
import org.infinispan.server.core.admin.embeddedserver.EmbeddedServerAdminOperationHandler;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.configuration.HotRodServerConfigurationBuilder;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="org.infinispan.client.hotrod.query.schema.SchemaUpdateMetadataTest")
public class SchemaUpdateMetadataTest
extends SingleHotRodServerTest {
    public static final ProgrammerSchemaImpl PROGRAMMER_SCHEMA = new ProgrammerSchemaImpl();
    public static final String QUERY_SORT = "from io.pro.Programmer p order by p.contributions";

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder config = new ConfigurationBuilder();
        config.indexing().enable().storage(IndexStorage.LOCAL_HEAP).addIndexedEntity("io.pro.Programmer");
        return TestCacheManagerFactory.createServerModeCacheManager((ConfigurationBuilder)config);
    }

    @Override
    protected SerializationContextInitializer contextInitializer() {
        return PROGRAMMER_SCHEMA;
    }

    @Override
    protected HotRodServer createHotRodServer() {
        HotRodServerConfigurationBuilder serverBuilder = new HotRodServerConfigurationBuilder();
        serverBuilder.adminOperationsHandler((AdminOperationsHandler)new EmbeddedServerAdminOperationHandler());
        return HotRodClientTestingUtil.startHotRodServer(this.cacheManager, serverBuilder);
    }

    @Test
    public void test() throws Exception {
        RemoteCache remoteCache = this.remoteCacheManager.getCache();
        this.cache.put((Object)1, (Object)new Programmer("fax4ever", 300));
        Query kQuery = remoteCache.query(QUERY_SORT);
        QueryResult kResult = kQuery.execute();
        Assertions.assertThat((int)kResult.count().value()).isEqualTo(1);
        this.verifySortable(false);
        this.queryIsOnTheCache(true);
        this.updateTheSchemaAndReindex();
        this.verifySortable(true);
        this.queryIsOnTheCache(false);
        kQuery = remoteCache.query(QUERY_SORT);
        kResult = kQuery.execute();
        Assertions.assertThat((int)kResult.count().value()).isEqualTo(1);
        this.queryIsOnTheCache(true);
    }

    private void queryIsOnTheCache(boolean isPresent) {
        QueryCache queryCache = this.getGlobalQueryCache();
        AtomicBoolean present = new AtomicBoolean(true);
        queryCache.get(this.cache.getName(), QUERY_SORT, null, IckleParsingResult.class, (qs, accumulators) -> {
            present.set(false);
            return null;
        });
        Assertions.assertThat((boolean)present.get()).isEqualTo(isPresent);
    }

    private QueryCache getGlobalQueryCache() {
        return (QueryCache)ComponentRegistry.componentOf((Cache)this.cache, QueryCache.class);
    }

    private void updateTheSchemaAndReindex() {
        String newProtoFile = ResourceUtils.getResourceAsString(((Object)((Object)this)).getClass(), (String)"/proto/pro-sortable.proto");
        this.cacheManager.getCache("___protobuf_metadata").put((Object)PROGRAMMER_SCHEMA.getProtoFileName(), (Object)newProtoFile);
        this.remoteCacheManager.administration().reindexCache(this.cache.getName());
    }

    private void verifySortable(boolean expected) {
        Descriptor descriptor = this.descriptor();
        FieldDescriptor fieldDescriptor = descriptor.findFieldByName("contributions");
        Map annotations = fieldDescriptor.getAnnotations();
        Assertions.assertThat((Map)annotations).containsKey((Object)"Basic");
        AnnotationElement.Annotation basic = (AnnotationElement.Annotation)annotations.get("Basic");
        AnnotationElement.Value sortable = basic.getAttributeValue("sortable");
        Assertions.assertThat((String)sortable.toString()).isEqualTo("" + expected);
    }

    private Descriptor descriptor() {
        ProtobufMatcher matcher = (ProtobufMatcher)ComponentRegistry.componentOf((Cache)this.cache, ProtobufMatcher.class);
        Assertions.assertThat((Object)matcher).isNotNull();
        ObjectPropertyHelper propertyHelper = matcher.getPropertyHelper();
        Assertions.assertThat((Object)propertyHelper).isNotNull();
        Descriptor descriptor = (Descriptor)propertyHelper.getEntityMetadata("io.pro.Programmer");
        Assertions.assertThat((Object)descriptor).isNotNull();
        return descriptor;
    }
}

