/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.query.testdomain.protobuf;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.infinispan.api.annotations.indexing.Basic;
import org.infinispan.api.annotations.indexing.Embedded;
import org.infinispan.api.annotations.indexing.Indexed;
import org.infinispan.client.hotrod.query.testdomain.protobuf.LimitsPB;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoName;
import org.infinispan.query.dsl.embedded.testdomain.Account;
import org.infinispan.query.dsl.embedded.testdomain.Limits;

@Indexed
@ProtoName(value="Account")
public class AccountPB
implements Account {
    private int id;
    private String description;
    private Date creationDate;
    private LimitsPB limits;
    private LimitsPB hardLimits;
    private List<byte[]> blurb = new ArrayList<byte[]>();
    private Account.Currency[] currencies = new Account.Currency[0];

    public AccountPB() {
        this.hardLimits = new LimitsPB();
        this.hardLimits.setMaxTransactionLimit(5000.0);
        this.hardLimits.setMaxDailyLimit(10000.0);
    }

    @ProtoFactory
    AccountPB(int id, String description, Date creationDate, LimitsPB limits, LimitsPB hardLimits, List<byte[]> blurb, Account.Currency[] currencies) {
        this.id = id;
        this.description = description;
        this.creationDate = creationDate;
        this.limits = limits;
        this.hardLimits = hardLimits;
        this.blurb = blurb;
        this.currencies = currencies;
    }

    @Basic(projectable=true, sortable=true)
    @ProtoField(value=1, defaultValue="0")
    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    @Basic(projectable=true, sortable=true)
    @ProtoField(value=2, defaultValue="Checking account")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Basic(projectable=true, sortable=true)
    @ProtoField(value=3)
    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    @Embedded
    @ProtoField(value=4)
    public LimitsPB getLimits() {
        return this.limits;
    }

    public void setLimits(Limits limits) {
        this.limits = (LimitsPB)limits;
    }

    @Embedded
    @ProtoField(value=5)
    public LimitsPB getHardLimits() {
        return this.hardLimits;
    }

    public void setHardLimits(Limits hardLimits) {
        this.hardLimits = (LimitsPB)hardLimits;
    }

    @Basic(projectable=true)
    @ProtoField(value=6)
    public List<byte[]> getBlurb() {
        return this.blurb;
    }

    public void setBlurb(List<byte[]> blurb) {
        this.blurb = blurb;
    }

    private boolean blurbEquals(List<byte[]> otherBlurbs) {
        if (otherBlurbs == this.blurb) {
            return true;
        }
        if (otherBlurbs == null || this.blurb == null || otherBlurbs.size() != this.blurb.size()) {
            return false;
        }
        for (int i = 0; i < this.blurb.size(); ++i) {
            if (Arrays.equals(this.blurb.get(i), otherBlurbs.get(i))) continue;
            return false;
        }
        return true;
    }

    @ProtoField(value=7)
    public Account.Currency[] getCurrencies() {
        return this.currencies;
    }

    public void setCurrencies(Account.Currency[] currencies) {
        this.currencies = currencies;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountPB account = (AccountPB)o;
        return this.id == account.id && Objects.equals(this.description, account.description) && Objects.equals(this.creationDate, account.creationDate) && Objects.equals(this.limits, account.limits) && Objects.equals(this.hardLimits, account.hardLimits) && this.blurbEquals(account.blurb) && Arrays.equals(this.currencies, account.currencies);
    }

    public int hashCode() {
        int blurbHash = 0;
        if (this.blurb != null) {
            for (byte[] b : this.blurb) {
                blurbHash = 31 * blurbHash + Arrays.hashCode(b);
            }
        }
        return Objects.hash(this.id, this.description, this.creationDate, this.limits, this.hardLimits, blurbHash, Arrays.hashCode(this.currencies));
    }

    public String toString() {
        return "AccountPB{id=" + this.id + ", description='" + this.description + "', creationDate='" + String.valueOf(this.creationDate) + "', limits=" + String.valueOf(this.limits) + ", hardLimits=" + String.valueOf(this.hardLimits) + ", blurb=" + String.valueOf(this.blurb != null ? this.blurb.stream().map(Arrays::toString).collect(Collectors.toList()) : "null") + ", currencies=" + Arrays.toString(this.currencies) + "}";
    }
}

