/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.query.type;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.query.testdomain.protobuf.CalculusIndexed;
import org.infinispan.client.hotrod.query.testdomain.protobuf.CalculusIndexedSchemaImpl;
import org.infinispan.client.hotrod.test.SingleHotRodServerTest;
import org.infinispan.commons.api.query.Query;
import org.infinispan.commons.api.query.QueryResult;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.IndexStorage;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="org.infinispan.client.hotrod.query.type.BigIntegerBigDecimalIndexedTest")
public class BigIntegerBigDecimalIndexedTest
extends SingleHotRodServerTest {
    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder config = new ConfigurationBuilder();
        config.indexing().enable().storage(IndexStorage.LOCAL_HEAP).addIndexedEntity("lab.indexed.CalculusIndexed");
        return TestCacheManagerFactory.createServerModeCacheManager((ConfigurationBuilder)config);
    }

    @Override
    protected SerializationContextInitializer contextInitializer() {
        return new CalculusIndexedSchemaImpl();
    }

    @Test
    public void test() {
        RemoteCache remoteCache = this.remoteCacheManager.getCache();
        remoteCache.put((Object)"1", (Object)new CalculusIndexed("blablabla", BigInteger.TEN, BigDecimal.valueOf(2.2), BigDecimal.valueOf(2.2)));
        CalculusIndexed calculus = (CalculusIndexed)remoteCache.get((Object)"1");
        Assertions.assertThat((BigInteger)calculus.getPurchases()).isEqualTo(10);
        Assertions.assertThat((BigDecimal)calculus.getProspect()).isEqualTo((Object)BigDecimal.valueOf(2.2));
        Query query = remoteCache.query("from lab.indexed.CalculusIndexed c where c.purchases > 9");
        QueryResult result = query.execute();
        Assertions.assertThat((List)result.list()).extracting("name").containsExactly(new Object[]{"blablabla"});
        query = remoteCache.query("from lab.indexed.CalculusIndexed c where c.prospect = 2.2");
        result = query.execute();
        Assertions.assertThat((List)result.list()).extracting("name").containsExactly(new Object[]{"blablabla"});
        query = remoteCache.query("from lab.indexed.CalculusIndexed c where c.prospect = 2.0");
        result = query.execute();
        Assertions.assertThat((List)result.list()).extracting("name").containsExactly(new Object[]{"blablabla"});
        query = remoteCache.query("from lab.indexed.CalculusIndexed c where c.prospect = 3.0");
        result = query.execute();
        Assertions.assertThat((List)result.list()).isEmpty();
        query = remoteCache.query("from lab.indexed.CalculusIndexed c where c.decimal = 2.2");
        result = query.execute();
        Assertions.assertThat((List)result.list()).extracting("name").containsExactly(new Object[]{"blablabla"});
        query = remoteCache.query("from lab.indexed.CalculusIndexed c where c.decimal = 2.0");
        result = query.execute();
        Assertions.assertThat((List)result.list()).extracting("name").isEmpty();
    }
}

