/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.query.vector;

import java.util.List;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.Assertions;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.test.SingleHotRodServerTest;
import org.infinispan.commons.api.query.Query;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.IndexStorage;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.query.model.Item;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="org.infinispan.client.hotrod.query.vector.VectorSearchRemoteTest")
public class VectorSearchRemoteTest
extends SingleHotRodServerTest {
    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder indexed = new ConfigurationBuilder();
        indexed.indexing().enable().storage(IndexStorage.LOCAL_HEAP).addIndexedEntity("Item");
        return TestCacheManagerFactory.createServerModeCacheManager((ConfigurationBuilder)indexed);
    }

    @Override
    protected SerializationContextInitializer contextInitializer() {
        return Item.ItemSchema.INSTANCE;
    }

    @Test
    public void test() {
        RemoteCache remoteCache = this.remoteCacheManager.getCache();
        for (byte item = 1; item <= 10; item = (byte)(item + 1)) {
            byte[] bytes = new byte[]{item, item, item};
            remoteCache.put((Object)item, (Object)new Item("c" + item, bytes, new float[]{1.1f * (float)item, 1.1f * (float)item, 1.1f * (float)item}, "bla" + item, Integer.valueOf(item)));
        }
        Query query = remoteCache.query("from Item i where i.byteVector <-> [7,6,7]~3");
        List hits = query.list();
        Assertions.assertThat((List)hits).extracting("code").containsExactly(new Object[]{"c7", "c6", "c8"});
        query = remoteCache.query("from Item i where i.floatVector <-> [7.1,7,3.1]~3");
        hits = query.list();
        Assertions.assertThat((List)hits).extracting("code").containsExactly(new Object[]{"c5", "c6", "c4"});
        query = remoteCache.query("from Item i where i.byteVector <-> [:a]~:b");
        query.setParameter("a", (Object)new byte[]{7, 6, 7});
        query.setParameter("b", (Object)3);
        hits = query.list();
        Assertions.assertThat((List)hits).extracting("code").containsExactly(new Object[]{"c7", "c6", "c8"});
        query = remoteCache.query("from Item i where i.floatVector <-> [:a]~:b");
        query.setParameter("a", (Object)new float[]{7.1f, 7.0f, 3.1f});
        query.setParameter("b", (Object)3);
        hits = query.list();
        Assertions.assertThat((List)hits).extracting("code").containsExactly(new Object[]{"c5", "c6", "c4"});
        Query scoreQuery = remoteCache.query("select score(i), i from Item i where i.byteVector <-> [7,6,7]~3");
        List scoreHits = scoreQuery.list();
        Assertions.assertThat((List)scoreHits).extracting(objects -> objects[1]).extracting("code").containsExactly(new Object[]{"c7", "c6", "c8"});
        ((AbstractListAssert)Assertions.assertThat((List)scoreHits).extracting(objects -> objects[0]).hasOnlyElementsOfType(Float.class)).isNotNull().allMatch(o -> !o.equals(Float.valueOf(Float.NaN)));
    }
}

