/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.retry;

import io.netty.channel.Channel;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Random;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.infinispan.Cache;
import org.infinispan.affinity.KeyAffinityService;
import org.infinispan.affinity.KeyAffinityServiceFactory;
import org.infinispan.affinity.KeyGenerator;
import org.infinispan.client.hotrod.MetadataValue;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.exceptions.TransportException;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelFactory;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelOperation;
import org.infinispan.client.hotrod.retry.AbstractRetryTest;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.client.hotrod.test.InternalRemoteCacheManager;
import org.infinispan.client.hotrod.test.NoopChannelOperation;
import org.infinispan.commons.marshall.ProtoStreamMarshaller;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.remoting.transport.Address;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.testng.Assert;
import org.testng.annotations.Test;

@CleanupAfterMethod
@Test(testName="client.hotrod.retry.DistributionRetryTest", groups={"functional"})
public class DistributionRetryTest
extends AbstractRetryTest {
    private int retries = 0;

    @Override
    protected org.infinispan.configuration.cache.ConfigurationBuilder getCacheConfig() {
        org.infinispan.configuration.cache.ConfigurationBuilder builder = HotRodTestingUtil.hotRodCacheConfiguration((org.infinispan.configuration.cache.ConfigurationBuilder)DistributionRetryTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false));
        builder.clustering().hash().numOwners(1);
        return builder;
    }

    @Override
    protected void amendRemoteCacheManagerConfiguration(ConfigurationBuilder builder) {
        builder.maxRetries(this.retries);
    }

    private boolean nextOperationShouldFail() {
        return this.retries == 0;
    }

    private void assertOperationFailsWithTransport(Object key) {
        Exceptions.expectException(TransportException.class, (String)".*", () -> this.remoteCache.get(key));
    }

    public void testGet() throws Exception {
        Object key = this.generateKeyAndShutdownServer();
        log.info((Object)"Starting actual test");
        if (this.nextOperationShouldFail()) {
            this.assertOperationFailsWithTransport(key);
        }
        this.resetStats();
        Assert.assertEquals((Object)this.remoteCache.get(key), (Object)"v");
    }

    public void testPut() throws Exception {
        Object key = this.generateKeyAndShutdownServer();
        log.info((Object)"Here it starts");
        if (this.nextOperationShouldFail()) {
            this.assertOperationFailsWithTransport(key);
        }
        Assert.assertEquals((Object)this.remoteCache.put(key, (Object)"v0"), (Object)"v");
    }

    public void testRemove() throws Exception {
        Object key = this.generateKeyAndShutdownServer();
        if (this.nextOperationShouldFail()) {
            this.assertOperationFailsWithTransport(key);
        }
        Assert.assertEquals((Object)"v", (Object)this.remoteCache.remove(key));
    }

    public void testContains() throws Exception {
        Object key = this.generateKeyAndShutdownServer();
        if (this.nextOperationShouldFail()) {
            this.assertOperationFailsWithTransport(key);
        }
        this.resetStats();
        Assert.assertEquals((boolean)true, (boolean)this.remoteCache.containsKey(key));
    }

    public void testGetWithMetadata() throws Exception {
        Object key = this.generateKeyAndShutdownServer();
        if (this.nextOperationShouldFail()) {
            this.assertOperationFailsWithTransport(key);
        }
        this.resetStats();
        MetadataValue value = this.remoteCache.getWithMetadata(key);
        Assert.assertEquals((Object)"v", (Object)value.getValue());
    }

    public void testPutIfAbsent() throws Exception {
        Object key = this.generateKeyAndShutdownServer();
        if (this.nextOperationShouldFail()) {
            this.assertOperationFailsWithTransport(key);
        }
        Assert.assertEquals(null, (Object)this.remoteCache.putIfAbsent((Object)"noSuchKey", (Object)"someValue"));
        Assert.assertEquals((Object)"someValue", (Object)this.remoteCache.get((Object)"noSuchKey"));
    }

    public void testReplace() throws Exception {
        Object key = this.generateKeyAndShutdownServer();
        if (this.nextOperationShouldFail()) {
            this.assertOperationFailsWithTransport(key);
        }
        Assert.assertEquals((Object)"v", (Object)this.remoteCache.replace(key, (Object)"v2"));
    }

    public void testReplaceIfUnmodified() throws Exception {
        Object key = this.generateKeyAndShutdownServer();
        if (this.nextOperationShouldFail()) {
            this.assertOperationFailsWithTransport(key);
        }
        Assert.assertEquals((boolean)false, (boolean)this.remoteCache.replaceWithVersion(key, (Object)"v2", 12L));
    }

    public void testRemoveIfUnmodified() throws Exception {
        Object key = this.generateKeyAndShutdownServer();
        if (this.nextOperationShouldFail()) {
            this.assertOperationFailsWithTransport(key);
        }
        this.resetStats();
        Assert.assertEquals((boolean)false, (boolean)this.remoteCache.removeWithVersion(key, 12L));
    }

    public void testClear() throws Exception {
        Object key = this.generateKeyAndShutdownServer();
        if (this.nextOperationShouldFail()) {
            this.assertOperationFailsWithTransport(key);
        }
        this.resetStats();
        this.remoteCache.clear();
        Assert.assertEquals((boolean)false, (boolean)this.remoteCache.containsKey(key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object generateKeyAndShutdownServer() throws IOException, ClassNotFoundException, InterruptedException {
        this.resetStats();
        Cache cache = this.manager(1).getCache();
        ExecutorService ex = Executors.newSingleThreadExecutor(this.getTestThreadFactory("KeyGenerator"));
        KeyAffinityService kaf = KeyAffinityServiceFactory.newKeyAffinityService((Cache)cache, (Executor)ex, (KeyGenerator)new ByteKeyGenerator(), (int)2, (boolean)true);
        Address address = cache.getAdvancedCache().getRpcManager().getTransport().getAddress();
        byte[] keyBytes = (byte[])kaf.getKeyForAddress(address);
        String key = ByteKeyGenerator.getStringObject(keyBytes);
        ex.shutdownNow();
        kaf.stop();
        this.remoteCache.put((Object)key, (Object)"v");
        this.assertOnlyServerHit(this.getAddress(this.hotRodServer2));
        ChannelFactory channelFactory = ((InternalRemoteCacheManager)this.remoteCacheManager).getChannelFactory();
        ProtoStreamMarshaller m = new ProtoStreamMarshaller();
        Channel channel = (Channel)((NoopChannelOperation)channelFactory.fetchChannelAndInvoke((Object)m.objectToByteBuffer((Object)key, 64), null, RemoteCacheManager.cacheNameBytes(), (ChannelOperation)new NoopChannelOperation())).join();
        try {
            Assert.assertEquals((Object)channel.remoteAddress(), (Object)new InetSocketAddress(this.hotRodServer2.getHost(), (int)this.hotRodServer2.getPort()));
        }
        finally {
            channelFactory.releaseChannel(channel);
        }
        log.info((Object)"About to stop Hot Rod server 2");
        HotRodClientTestingUtil.killServers(this.hotRodServer2);
        DistributionRetryTest.eventually(() -> !channel.isActive());
        return key;
    }

    private DistributionRetryTest withRetries(int retries) {
        this.retries = retries;
        return this;
    }

    protected String parameters() {
        return "[retries=" + this.retries + "]";
    }

    public Object[] factory() {
        return new Object[]{new DistributionRetryTest().withRetries(0), new DistributionRetryTest().withRetries(10)};
    }

    public static class ByteKeyGenerator
    implements KeyGenerator<Object> {
        Random r = new Random();

        public byte[] getKey() {
            String result = String.valueOf(this.r.nextLong());
            try {
                return new ProtoStreamMarshaller().objectToByteBuffer((Object)result, 64);
            }
            catch (IOException | InterruptedException e) {
                throw new RuntimeException(e);
            }
        }

        public static String getStringObject(byte[] bytes) {
            try {
                return (String)new ProtoStreamMarshaller().objectFromByteBuffer(bytes);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

