/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.retry;

import org.infinispan.Cache;
import org.infinispan.client.hotrod.retry.AbstractRetryTest;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.remoting.rpc.RpcManagerImpl;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(testName="client.hotrod.retry.ReplicationHitsTest", groups={"functional"})
public class ReplicationHitsTest
extends AbstractRetryTest {
    public static final int NUM_WRITES = 100;

    public void testPut() {
        this.resetStats();
        this.assertNoHits();
        for (Cache c : this.caches()) {
            ((RpcManagerImpl)c.getAdvancedCache().getRpcManager()).setStatisticsEnabled(true);
        }
        for (int i = 0; i < 100; ++i) {
            this.remoteCache.put((Object)("k" + i), (Object)"v1");
        }
        long totalReplications = 0L;
        for (Cache c : this.caches()) {
            totalReplications += ((RpcManagerImpl)c.getAdvancedCache().getRpcManager()).getReplicationCount();
        }
        AssertJUnit.assertEquals((long)100L, (long)totalReplications);
    }

    @Override
    protected ConfigurationBuilder getCacheConfig() {
        ConfigurationBuilder config = ReplicationHitsTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.REPL_SYNC, (boolean)false);
        config.clustering().hash().numSegments(60);
        return config;
    }
}

