/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.retry;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.exceptions.RemoteNodeSuspectException;
import org.infinispan.client.hotrod.impl.Util;
import org.infinispan.client.hotrod.impl.operations.RetryOnFailureOperation;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelFactory;
import org.infinispan.client.hotrod.impl.transport.netty.HeaderDecoder;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.test.AbstractInfinispanTest;
import org.mockito.Mockito;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="client.hotrod.retry.RetryOnFailureUnitTest")
public class RetryOnFailureUnitTest
extends AbstractInfinispanTest {
    private final Channel mockChannel = (Channel)Mockito.mock(Channel.class);

    public void testNoRetryOnTransportFailure() {
        this.doRetryTest(0, true);
    }

    public void testNoRetryOnExecuteFailure() {
        this.doRetryTest(0, false);
    }

    public void testSingleRetryOnTransportFailure() {
        this.doRetryTest(1, true);
    }

    public void testSingleRetryOnExecuteFailure() {
        this.doRetryTest(1, false);
    }

    public void testMultipleRetryOnTransportFailure() {
        this.doRetryTest(3, true);
    }

    public void testMultipleRetryOnExecuteFailure() {
        this.doRetryTest(3, false);
    }

    private void doRetryTest(int maxRetry, boolean failOnTransport) {
        ChannelFactory mockTransport = (ChannelFactory)Mockito.mock(ChannelFactory.class);
        Mockito.when((Object)mockTransport.getMaxRetries()).thenReturn((Object)maxRetry);
        TestOperation testOperation = new TestOperation(mockTransport, failOnTransport);
        Exceptions.expectExceptionNonStrict(HotRodClientException.class, () -> Util.await((CompletableFuture)testOperation.execute(), (long)10000L));
        if (failOnTransport) {
            AssertJUnit.assertEquals((String)"Wrong getChannel() invocation.", (int)(maxRetry + 1), (int)testOperation.channelInvocationCount.get());
            AssertJUnit.assertEquals((String)"Wrong execute() invocation.", (int)0, (int)testOperation.executeInvocationCount.get());
        } else {
            AssertJUnit.assertEquals((String)"Wrong getChannel() invocation.", (int)(maxRetry + 1), (int)testOperation.channelInvocationCount.get());
            AssertJUnit.assertEquals((String)"Wrong execute() invocation.", (int)(maxRetry + 1), (int)testOperation.executeInvocationCount.get());
        }
    }

    private class TestOperation
    extends RetryOnFailureOperation<Void> {
        private final AtomicInteger channelInvocationCount;
        private final AtomicInteger executeInvocationCount;
        private final boolean failOnTransport;

        TestOperation(ChannelFactory channelFactory, boolean failOnTransport) {
            super((short)0, (short)0, null, channelFactory, null, null, 0, HotRodClientTestingUtil.newRemoteConfigurationBuilder().build(), null, null);
            this.failOnTransport = failOnTransport;
            this.channelInvocationCount = new AtomicInteger(0);
            this.executeInvocationCount = new AtomicInteger(0);
        }

        protected void fetchChannelAndInvoke(int retryCount, Set<SocketAddress> failedServers) {
            this.channelInvocationCount.incrementAndGet();
            if (this.failOnTransport) {
                this.cancel(null, (Throwable)new RemoteNodeSuspectException("Induced Failure", 1L, 1));
            } else {
                this.invoke(RetryOnFailureUnitTest.this.mockChannel);
            }
        }

        protected void executeOperation(Channel channel) {
            this.executeInvocationCount.incrementAndGet();
            if (!this.failOnTransport) {
                this.exceptionCaught(null, (Throwable)new RemoteNodeSuspectException("Induced Failure", 1L, 1));
            } else {
                this.complete(null);
            }
        }

        public void acceptResponse(ByteBuf buf, short status, HeaderDecoder decoder) {
            throw new UnsupportedOperationException();
        }
    }
}

