/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.retry;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.infinispan.AdvancedCache;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelOperation;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelRecord;
import org.infinispan.client.hotrod.retry.SocketTimeoutFailureRetryTest;
import org.infinispan.client.hotrod.test.NoopChannelOperation;
import org.infinispan.test.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.retry.SingleServerSocketTimeoutTest")
public class SingleServerSocketTimeoutTest
extends SocketTimeoutFailureRetryTest {
    public SingleServerSocketTimeoutTest() {
        this.nbrOfServers = 1;
    }

    public void testChannelIsReUtilizedForRetry() throws Exception {
        Integer key = 2;
        this.remoteCache.put((Object)key, (Object)"v1");
        AssertJUnit.assertEquals((Object)"v1", (Object)this.remoteCache.get((Object)key));
        AdvancedCache<?, ?> nextCache = this.cacheToHit(key);
        SocketTimeoutFailureRetryTest.DelayingInterceptor interceptor = (SocketTimeoutFailureRetryTest.DelayingInterceptor)TestingUtil.extractInterceptorChain(nextCache).findInterceptorExtending(SocketTimeoutFailureRetryTest.DelayingInterceptor.class);
        CompletableFuture<Void> delay = new CompletableFuture<Void>();
        interceptor.delayNextRequest(delay);
        AssertJUnit.assertEquals((long)0L, (long)this.remoteCacheManager.getChannelFactory().getRetries());
        int connectionsBefore = this.channelFactory.getNumActive() + this.channelFactory.getNumIdle();
        AssertJUnit.assertEquals((Object)"v1", (Object)this.remoteCache.get((Object)key));
        AssertJUnit.assertEquals((long)1L, (long)this.remoteCacheManager.getChannelFactory().getRetries());
        AssertJUnit.assertEquals((int)connectionsBefore, (int)(this.channelFactory.getNumActive() + this.channelFactory.getNumIdle()));
        Channel initialChannel = (Channel)((NoopChannelOperation)this.remoteCacheManager.getChannelFactory().fetchChannelAndInvoke((SocketAddress)this.getAddress(this.hotRodServer1), (ChannelOperation)new NoopChannelOperation())).get(10L, TimeUnit.SECONDS);
        ChannelRecord.of((Channel)initialChannel).release(initialChannel);
        Assertions.assertThat((boolean)initialChannel.isActive()).isTrue();
        delay.complete(null);
        AssertJUnit.assertEquals((Object)"v1", (Object)this.remoteCache.get((Object)key));
        AssertJUnit.assertEquals((long)1L, (long)this.remoteCacheManager.getChannelFactory().getRetries());
        Channel other = (Channel)((NoopChannelOperation)this.remoteCacheManager.getChannelFactory().fetchChannelAndInvoke((SocketAddress)this.getAddress(this.hotRodServer1), (ChannelOperation)new NoopChannelOperation())).get(10L, TimeUnit.SECONDS);
        AssertJUnit.assertEquals((int)connectionsBefore, (int)(this.channelFactory.getNumActive() + this.channelFactory.getNumIdle()));
        Assertions.assertThat((boolean)initialChannel.isActive()).isTrue();
        Assertions.assertThat((Comparable)other).isSameAs((Object)initialChannel);
    }
}

