/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.retry;

import io.netty.channel.Channel;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.infinispan.client.hotrod.CacheTopologyInfo;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelOperation;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelRecord;
import org.infinispan.client.hotrod.retry.AbstractRetryTest;
import org.infinispan.client.hotrod.test.NoopChannelOperation;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.util.concurrent.AggregateCompletionStage;
import org.infinispan.util.concurrent.CompletionStages;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.retry.TopologyUpdateRetryTest")
public class TopologyUpdateRetryTest
extends AbstractRetryTest {
    @Override
    protected ConfigurationBuilder getCacheConfig() {
        return HotRodTestingUtil.hotRodCacheConfiguration((ConfigurationBuilder)TopologyUpdateRetryTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.REPL_SYNC, (boolean)false));
    }

    public void testTopologyChangeWithQueuedOperations() throws Exception {
        InetSocketAddress address = (InetSocketAddress)this.channelFactory.getConsistentHash(RemoteCacheManager.cacheNameBytes()).getServer((Object)HotRodTestingUtil.marshall((Object)1));
        Channel channel = (Channel)((NoopChannelOperation)this.channelFactory.fetchChannelAndInvoke((SocketAddress)address, (ChannelOperation)new NoopChannelOperation())).get(10L, TimeUnit.SECONDS);
        AggregateCompletionStage operations = CompletionStages.aggregateCompletionStage();
        for (int i = 0; i < 10; ++i) {
            operations.dependsOn((CompletionStage)this.remoteCache.putAsync((Object)1, (Object)("v" + i)));
        }
        CacheTopologyInfo currentInfo = this.channelFactory.getCacheTopologyInfo(RemoteCacheManager.cacheNameBytes());
        Collection servers = this.channelFactory.getServers();
        servers.remove(address);
        InetSocketAddress[] newServers = servers.toArray(new InetSocketAddress[0]);
        SocketAddress[][] owners = new SocketAddress[256][];
        for (int i = 0; i < 256; ++i) {
            owners[i] = newServers;
        }
        this.channelFactory.receiveTopology(RemoteCacheManager.cacheNameBytes(), this.channelFactory.getTopologyAge(), currentInfo.getTopologyId() + 1, newServers, owners, (short)3);
        TopologyUpdateRetryTest.eventually(() -> this.channelFactory.getNumActive() == 0);
        Assertions.assertThat((boolean)channel.isActive()).isTrue();
        ChannelRecord.of((Channel)channel).release(channel);
        operations.freeze().toCompletableFuture().get(10L, TimeUnit.SECONDS);
        TopologyUpdateRetryTest.eventually(() -> !channel.isActive());
    }
}

