/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.size;

import org.assertj.core.api.Assertions;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.annotation.model.Essay;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.test.SingleHotRodServerTest;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.server.core.test.ServerTestingUtil;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.configuration.HotRodServerConfigurationBuilder;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="org.infinispan.client.hotrod.size.HugeProtobufMessageTest")
public class HugeProtobufMessageTest
extends SingleHotRodServerTest {
    public static final int SIZE = 68000000;

    @Override
    protected HotRodServer createHotRodServer() {
        String host = HotRodTestingUtil.host();
        int port = ServerTestingUtil.findFreePort();
        HotRodServerConfigurationBuilder builder = new HotRodServerConfigurationBuilder();
        return HotRodTestingUtil.startHotRodServer((EmbeddedCacheManager)this.cacheManager, (String)host, (int)port, (HotRodServerConfigurationBuilder)builder, (boolean)false);
    }

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        EmbeddedCacheManager manager = TestCacheManagerFactory.createServerModeCacheManager();
        manager.defineConfiguration("homeworks", new org.infinispan.configuration.cache.ConfigurationBuilder().build());
        return manager;
    }

    @Override
    protected ConfigurationBuilder createHotRodClientConfigurationBuilder(String host, int serverPort) {
        return super.createHotRodClientConfigurationBuilder(host, serverPort).socketTimeout(20000);
    }

    @Override
    protected SerializationContextInitializer contextInitializer() {
        return Essay.EssaySchema.INSTANCE;
    }

    @Test
    public void testSearches() {
        RemoteCache remoteCache = this.remoteCacheManager.getCache("homeworks");
        remoteCache.put((Object)1, (Object)new Essay("my-very-extensive-essay", this.makeHugeString()));
        Essay essay = (Essay)remoteCache.get((Object)1);
        Assertions.assertThat((Object)essay).isNotNull();
    }

    private String makeHugeString() {
        char[] chars = new char[68000000];
        for (int i = 0; i < 68000000; ++i) {
            char delta = (char)(i % 20);
            chars[i] = (char)(97 + delta);
        }
        return new String(chars);
    }
}

