/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.stress.near;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.Callable;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.NearCacheMode;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.client.hotrod.test.InternalRemoteCacheManager;
import org.infinispan.client.hotrod.test.RemoteCacheManagerCallable;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test(groups={"manual"}, testName="client.hotrod.stress.near.EagerNearCacheStressTest")
public class EagerNearCacheStressTest {
    static int NUM_CLIENTS = 3;
    static int NUM_THREADS_PER_CLIENT = 10;
    static ExecutorService EXEC = Executors.newCachedThreadPool();
    static final int NUM_OPERATIONS = 10000000;
    static final int NUM_KEYS_PRELOAD = 1000;
    static final int KEY_RANGE = 1000;

    @AfterClass
    public static void shutdownExecutor() {
        EXEC.shutdown();
    }

    EmbeddedCacheManager createCacheManager() {
        return TestCacheManagerFactory.createCacheManager((org.infinispan.configuration.cache.ConfigurationBuilder)HotRodTestingUtil.hotRodCacheConfiguration());
    }

    RemoteCacheManager getRemoteCacheManager(int port) {
        return this.getRemoteCacheManager(port, NearCacheMode.DISABLED, -1);
    }

    RemoteCacheManager getRemoteCacheManager(int port, NearCacheMode nearCacheMode, int maxEntries) {
        ConfigurationBuilder builder = HotRodClientTestingUtil.newRemoteConfigurationBuilder();
        builder.nearCache().mode(nearCacheMode).maxEntries(maxEntries);
        builder.addServer().host("127.0.0.1").port(port);
        return new InternalRemoteCacheManager(builder.build());
    }

    public void testLocalPreloadAndGetPut10to1() {
        this.runPreloadAndOps(NearCacheMode.INVALIDATED, -1, 0.9);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runPreloadAndOps(NearCacheMode nearCacheMode, int maxEntries, double getRatio) {
        EmbeddedCacheManager cm = this.createCacheManager();
        int port = 11222;
        this.preloadData(port);
        RemoteCacheManager[] remotecms = new RemoteCacheManager[NUM_CLIENTS];
        for (int i = 0; i < NUM_CLIENTS; ++i) {
            remotecms[i] = this.getRemoteCacheManager(port, nearCacheMode, maxEntries);
        }
        try {
            this.ops(remotecms, getRatio);
        }
        catch (Throwable throwable) {
            HotRodClientTestingUtil.killRemoteCacheManagers(remotecms);
            TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{cm});
            throw throwable;
        }
        HotRodClientTestingUtil.killRemoteCacheManagers(remotecms);
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{cm});
    }

    void ops(RemoteCacheManager[] remotecms, double getRatio) {
        CyclicBarrier barrier = new CyclicBarrier(NUM_CLIENTS * NUM_THREADS_PER_CLIENT + 1);
        ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>(NUM_CLIENTS * NUM_THREADS_PER_CLIENT);
        for (RemoteCacheManager remotecm : remotecms) {
            RemoteCache remote = remotecm.getCache();
            for (int i = 0; i < NUM_THREADS_PER_CLIENT; ++i) {
                Main call = new Main(barrier, (RemoteCache<Integer, String>)remote, getRatio);
                futures.add(EXEC.submit(call));
            }
        }
        EagerNearCacheStressTest.barrierAwait(barrier);
        EagerNearCacheStressTest.barrierAwait(barrier);
        for (Future future : futures) {
            this.futureGet(future);
        }
    }

    void preloadData(int port) {
        HotRodClientTestingUtil.withRemoteCacheManager(new RemoteCacheManagerCallable(this.getRemoteCacheManager(port)){

            @Override
            public void call() {
                RemoteCache remote = this.rcm.getCache();
                HashMap<Integer, String> map = new HashMap<Integer, String>();
                for (int i = 0; i < 1000; ++i) {
                    map.put(i, TestingUtil.generateRandomString((int)512));
                }
                remote.putAll(map);
            }
        });
    }

    static int barrierAwait(CyclicBarrier barrier) {
        try {
            return barrier.await();
        }
        catch (InterruptedException | BrokenBarrierException e) {
            throw new AssertionError((Object)e);
        }
    }

    <T> T futureGet(Future<T> future) {
        try {
            return future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new AssertionError((Object)e);
        }
    }

    static final class Main
    extends Runner {
        static final ThreadLocalRandom R = ThreadLocalRandom.current();

        Main(CyclicBarrier barrier, RemoteCache<Integer, String> remote, double getRatio) {
            super(barrier, remote, getRatio);
        }

        @Override
        void run() {
            double maxGetKey = 1000.0 * this.getRatio;
            for (int i = 0; i < 10000000; ++i) {
                int key = R.nextInt(1000);
                if ((double)key < maxGetKey) {
                    String value = (String)this.remote.get((Object)key);
                    AssertJUnit.assertNotNull((Object)value);
                    continue;
                }
                String prev = (String)this.remote.put((Object)key, (Object)TestingUtil.generateRandomString((int)512));
                AssertJUnit.assertNull((Object)prev);
            }
        }
    }

    static abstract class Runner
    implements Callable<Void> {
        final CyclicBarrier barrier;
        final RemoteCache<Integer, String> remote;
        final double getRatio;

        Runner(CyclicBarrier barrier, RemoteCache<Integer, String> remote, double getRatio) {
            this.barrier = barrier;
            this.remote = remote;
            this.getRatio = getRatio;
        }

        @Override
        public Void call() throws Exception {
            EagerNearCacheStressTest.barrierAwait(this.barrier);
            try {
                this.run();
                Void void_ = null;
                return void_;
            }
            finally {
                EagerNearCacheStressTest.barrierAwait(this.barrier);
            }
        }

        abstract void run();
    }
}

