/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.tracing;

import io.opentelemetry.sdk.trace.data.SpanData;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.test.MultiHotRodServersTest;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.server.core.telemetry.inmemory.InMemoryTelemetryClient;
import org.infinispan.telemetry.SpanCategory;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test(groups={"tracing"}, testName="org.infinispan.client.hotrod.tracing.TracingClusterTest")
public class TracingClusterTest
extends MultiHotRodServersTest {
    private static final int NUM_SERVERS = 3;
    private final InMemoryTelemetryClient telemetryClient = new InMemoryTelemetryClient();

    @Override
    protected void modifyGlobalConfiguration(GlobalConfigurationBuilder builder) {
        builder.tracing().collectorEndpoint("file://in-memory-local-process");
    }

    protected void createCacheManagers() throws Throwable {
        this.telemetryClient.reset();
        Assertions.assertThat((List)this.telemetryClient.finishedSpanItems()).isEmpty();
        ConfigurationBuilder config = TracingClusterTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false);
        config.tracing().enableCategory(SpanCategory.CLUSTER);
        this.createHotRodServers(3, config);
        this.waitForClusterToForm();
    }

    @Override
    @AfterClass(alwaysRun=true)
    protected void destroy() {
        this.telemetryClient.reset();
        super.destroy();
    }

    @Test
    public void spanExport() {
        RemoteCache cache1 = this.client(0).getCache();
        cache1.put((Object)"AAA", (Object)"aaa");
        cache1.put((Object)"AAA", (Object)"bbb");
        cache1.put((Object)"AAA", (Object)"ccc");
        TracingClusterTest.eventually(() -> this.telemetryClient.finishedSpanItems().toString(), () -> this.telemetryClient.finishedSpanItems().size() == 6, (long)10L, (TimeUnit)TimeUnit.SECONDS);
        List spanItems = this.telemetryClient.finishedSpanItems();
        Map spansByName = InMemoryTelemetryClient.aggregateByName((List)spanItems);
        Assertions.assertThat((Map)spansByName).hasSize(2);
        List parents = (List)spansByName.get("PUT");
        Assertions.assertThat((List)parents).hasSize(3);
        List children = (List)spansByName.get("PutKeyValueCommand");
        Assertions.assertThat((List)children).hasSize(3);
        HashSet<String> parentSpanIds = new HashSet<String>(3);
        String rootId = null;
        for (SpanData parent : parents) {
            parentSpanIds.add(parent.getSpanId());
            if (rootId == null) {
                rootId = parent.getParentSpanId();
                continue;
            }
            Assertions.assertThat(rootId).isEqualTo(parent.getParentSpanId());
        }
        for (SpanData child : children) {
            String parentSpanId = child.getParentSpanId();
            Assertions.assertThat((boolean)parentSpanIds.remove(parentSpanId)).isTrue();
        }
    }
}

