/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.tracing;

import io.opentelemetry.sdk.trace.data.SpanData;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManagerAdmin;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.client.hotrod.test.SingleHotRodServerTest;
import org.infinispan.commons.api.CacheContainerAdmin;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.dummy.DummyInMemoryStoreConfigurationBuilder;
import org.infinispan.server.core.admin.AdminOperationsHandler;
import org.infinispan.server.core.admin.embeddedserver.EmbeddedServerAdminOperationHandler;
import org.infinispan.server.core.telemetry.inmemory.InMemoryTelemetryClient;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.configuration.HotRodServerConfigurationBuilder;
import org.infinispan.telemetry.SpanCategory;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(groups={"tracing"}, testName="org.infinispan.client.hotrod.tracing.TracingPersistenceTest")
public class TracingPersistenceTest
extends SingleHotRodServerTest {
    private final InMemoryTelemetryClient telemetryClient = new InMemoryTelemetryClient();

    @Override
    protected void teardown() {
        this.telemetryClient.reset();
        super.teardown();
    }

    @Override
    protected HotRodServer createHotRodServer() {
        HotRodServerConfigurationBuilder serverBuilder = new HotRodServerConfigurationBuilder();
        serverBuilder.adminOperationsHandler((AdminOperationsHandler)new EmbeddedServerAdminOperationHandler());
        return HotRodClientTestingUtil.startHotRodServer(this.cacheManager, serverBuilder);
    }

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        this.telemetryClient.reset();
        Assertions.assertThat((List)this.telemetryClient.finishedSpanItems()).isEmpty();
        GlobalConfigurationBuilder global = new GlobalConfigurationBuilder().nonClusteredDefault();
        global.tracing().collectorEndpoint("file://in-memory-local-process");
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.tracing().enableCategory(SpanCategory.PERSISTENCE);
        ((DummyInMemoryStoreConfigurationBuilder)builder.persistence().passivation(false).addStore(DummyInMemoryStoreConfigurationBuilder.class)).purgeOnStartup(true);
        EmbeddedCacheManager manager = TestCacheManagerFactory.createServerModeCacheManager((GlobalConfigurationBuilder)global);
        manager.defineConfiguration("persistence", builder.build());
        return manager;
    }

    @Test
    public void test() throws Exception {
        RemoteCache remoteCache = this.remoteCacheManager.getCache("persistence");
        remoteCache.put((Object)1, (Object)"bla bla bla");
        remoteCache.put((Object)2, (Object)"one two three");
        ((RemoteCacheManagerAdmin)this.remoteCacheManager.administration().withFlags(new CacheContainerAdmin.AdminFlag[]{CacheContainerAdmin.AdminFlag.VOLATILE})).updateConfigurationAttribute("persistence", "tracing.categories", "cluster, container");
        remoteCache.put((Object)3, (Object)"foo bar baz");
        TracingPersistenceTest.eventually(() -> this.telemetryClient.finishedSpanItems().toString(), () -> this.telemetryClient.finishedSpanItems().size() == 5, (long)10L, (TimeUnit)TimeUnit.SECONDS);
        List spanItems = this.telemetryClient.finishedSpanItems();
        Map spansByName = InMemoryTelemetryClient.aggregateByName((List)spanItems);
        List parents = (List)spansByName.get("PUT");
        Assertions.assertThat((List)parents).hasSize(3);
        List children = (List)spansByName.get("writeToAllNonTxStores");
        Assertions.assertThat((List)children).hasSize(2);
        HashSet<String> parentSpanIds = new HashSet<String>(3);
        String rootId = null;
        for (SpanData parent : parents) {
            parentSpanIds.add(parent.getSpanId());
            if (rootId == null) {
                rootId = parent.getParentSpanId();
                continue;
            }
            Assertions.assertThat(rootId).isEqualTo(parent.getParentSpanId());
        }
        for (SpanData child : children) {
            String parentSpanId = child.getParentSpanId();
            Assertions.assertThat((boolean)parentSpanIds.remove(parentSpanId)).isTrue();
        }
    }
}

