/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.tracing;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.propagation.W3CTraceContextPropagator;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.trace.data.SpanData;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.annotation.model.Author;
import org.infinispan.client.hotrod.annotation.model.Poem;
import org.infinispan.client.hotrod.test.SingleHotRodServerTest;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.IndexStorage;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.server.core.telemetry.inmemory.InMemoryTelemetryClient;
import org.infinispan.telemetry.SpanCategory;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(groups={"tracing"}, testName="org.infinispan.client.hotrod.tracing.TracingPropagationTest")
public class TracingPropagationTest
extends SingleHotRodServerTest {
    private static final String CLIENT_SPAN_NAME = "user-client-side-span";
    private static final String PUT_OPERATION_SPAN_NAME = "PUT";
    private final InMemoryTelemetryClient telemetryClient = new InMemoryTelemetryClient();

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        this.telemetryClient.reset();
        Assertions.assertThat((List)this.telemetryClient.finishedSpanItems()).isEmpty();
        GlobalConfigurationBuilder global = new GlobalConfigurationBuilder().nonClusteredDefault();
        global.tracing().collectorEndpoint("file://in-memory-local-process");
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.indexing().enable().storage(IndexStorage.LOCAL_HEAP).addIndexedEntity("poem.Poem");
        EmbeddedCacheManager manager = TestCacheManagerFactory.createServerModeCacheManager((GlobalConfigurationBuilder)global);
        manager.defineConfiguration("poems", builder.build());
        return manager;
    }

    @Override
    protected void teardown() {
        this.telemetryClient.reset();
        super.teardown();
    }

    @Override
    protected SerializationContextInitializer contextInitializer() {
        return Poem.PoemSchema.INSTANCE;
    }

    @Test
    public void smokeTest() {
        RemoteCache remoteCache = this.remoteCacheManager.getCache("poems");
        this.telemetryClient.withinClientSideSpan(CLIENT_SPAN_NAME, () -> {
            Map<String, String> contextMap = TracingPropagationTest.getContextMap();
            Assertions.assertThat(contextMap).isNotEmpty();
            remoteCache.put((Object)1, (Object)new Poem(new Author("Edgar Allen Poe"), "The Raven", 1845));
            remoteCache.put((Object)2, (Object)new Poem(new Author("Emily Dickinson"), "Because I could not stop for Death", 1890));
        });
        TracingPropagationTest.eventually(() -> this.telemetryClient.finishedSpanItems().toString(), () -> this.telemetryClient.finishedSpanItems().size() == 3, (long)10L, (TimeUnit)TimeUnit.SECONDS);
        List allSpans = this.telemetryClient.finishedSpanItems();
        Map spansByName = InMemoryTelemetryClient.aggregateByName((List)allSpans);
        Assertions.assertThat((Map)spansByName).containsKeys((Object[])new String[]{PUT_OPERATION_SPAN_NAME, CLIENT_SPAN_NAME});
        List clientSpans = (List)spansByName.get(CLIENT_SPAN_NAME);
        Assertions.assertThat((List)clientSpans).hasSize(1);
        SpanData clientSpan = (SpanData)clientSpans.get(0);
        String clientTraceId = clientSpan.getTraceId();
        String clientSpanId = clientSpan.getSpanId();
        List serverSpans = (List)spansByName.get(PUT_OPERATION_SPAN_NAME);
        ((ListAssert)Assertions.assertThat((List)serverSpans).hasSize(2)).allSatisfy(spanData -> {
            Assertions.assertThat((String)spanData.getTraceId()).isEqualTo(clientTraceId);
            Assertions.assertThat((String)spanData.getParentSpanId()).isEqualTo(clientSpanId);
            Attributes attributes = spanData.getAttributes();
            Assertions.assertThat((String)((String)attributes.get(AttributeKey.stringKey((String)"cache")))).isEqualTo("poems");
            Assertions.assertThat((String)((String)attributes.get(AttributeKey.stringKey((String)"category")))).isEqualTo(SpanCategory.CONTAINER.toString());
        });
    }

    public static Map<String, String> getContextMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        W3CTraceContextPropagator.getInstance().inject(Context.current(), result, (carrier, key, value) -> carrier.put(key, value));
        return result;
    }
}

