/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.tracing;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.trace.data.SpanData;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManagerAdmin;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.client.hotrod.test.SingleHotRodServerTest;
import org.infinispan.commons.api.CacheContainerAdmin;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.core.admin.AdminOperationsHandler;
import org.infinispan.server.core.admin.embeddedserver.EmbeddedServerAdminOperationHandler;
import org.infinispan.server.core.telemetry.inmemory.InMemoryTelemetryClient;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.configuration.HotRodServerConfigurationBuilder;
import org.infinispan.telemetry.SpanCategory;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(groups={"tracing"}, testName="org.infinispan.client.hotrod.tracing.TracingRuntimeEnablingTest")
public class TracingRuntimeEnablingTest
extends SingleHotRodServerTest {
    private static final String CACHE_A = "cacheA";
    private static final String CACHE_B = "cacheB";
    private final InMemoryTelemetryClient telemetryClient = new InMemoryTelemetryClient();

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        this.telemetryClient.reset();
        Assertions.assertThat((List)this.telemetryClient.finishedSpanItems()).isEmpty();
        GlobalConfigurationBuilder global = new GlobalConfigurationBuilder().nonClusteredDefault();
        global.tracing().collectorEndpoint("file://in-memory-local-process");
        ConfigurationBuilder configA = new ConfigurationBuilder();
        configA.tracing().enable();
        ConfigurationBuilder configB = new ConfigurationBuilder();
        configB.tracing().disable();
        EmbeddedCacheManager manager = TestCacheManagerFactory.createServerModeCacheManager((GlobalConfigurationBuilder)global);
        manager.defineConfiguration(CACHE_A, configA.build());
        manager.defineConfiguration(CACHE_B, configB.build());
        return manager;
    }

    @Override
    protected HotRodServer createHotRodServer() {
        HotRodServerConfigurationBuilder serverBuilder = new HotRodServerConfigurationBuilder();
        serverBuilder.adminOperationsHandler((AdminOperationsHandler)new EmbeddedServerAdminOperationHandler());
        return HotRodClientTestingUtil.startHotRodServer(this.cacheManager, serverBuilder);
    }

    @Override
    protected void teardown() {
        this.telemetryClient.reset();
        super.teardown();
    }

    @Test
    public void test() {
        RemoteCache cacheA = this.remoteCacheManager.getCache(CACHE_A);
        RemoteCache cacheB = this.remoteCacheManager.getCache(CACHE_B);
        cacheA.put((Object)"AAA", (Object)"BBB");
        cacheB.put((Object)"BBB", (Object)"CCC");
        this.eventuallyEquals(1, () -> this.telemetryClient.finishedSpanItems().size());
        List result = this.telemetryClient.finishedSpanItems();
        SpanData span = (SpanData)result.get(0);
        Assertions.assertThat((String)span.getName()).isEqualTo("PUT");
        Attributes attributes = span.getAttributes();
        Assertions.assertThat((String)((String)attributes.get(AttributeKey.stringKey((String)"cache")))).isEqualTo(CACHE_A);
        Assertions.assertThat((String)((String)attributes.get(AttributeKey.stringKey((String)"category")))).isEqualTo(SpanCategory.CONTAINER.toString());
        this.telemetryClient.reset();
        ((RemoteCacheManagerAdmin)this.remoteCacheManager.administration().withFlags(new CacheContainerAdmin.AdminFlag[]{CacheContainerAdmin.AdminFlag.VOLATILE})).updateConfigurationAttribute(CACHE_A, "tracing.enabled", "false");
        ((RemoteCacheManagerAdmin)this.remoteCacheManager.administration().withFlags(new CacheContainerAdmin.AdminFlag[]{CacheContainerAdmin.AdminFlag.VOLATILE})).updateConfigurationAttribute(CACHE_B, "tracing.enabled", "true");
        cacheA.put((Object)"CCC", (Object)"DDD");
        cacheB.put((Object)"DDD", (Object)"EEE");
        this.eventuallyEquals(1, () -> this.telemetryClient.finishedSpanItems().size());
        result = this.telemetryClient.finishedSpanItems();
        span = (SpanData)result.get(0);
        Assertions.assertThat((String)span.getName()).isEqualTo("PUT");
        attributes = span.getAttributes();
        Assertions.assertThat((String)((String)attributes.get(AttributeKey.stringKey((String)"cache")))).isEqualTo(CACHE_B);
        Assertions.assertThat((String)((String)attributes.get(AttributeKey.stringKey((String)"category")))).isEqualTo(SpanCategory.CONTAINER.toString());
    }
}

