/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.tx;

import jakarta.transaction.Transaction;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.TransactionMode;
import org.infinispan.client.hotrod.test.MultiHotRodServersTest;
import org.infinispan.client.hotrod.transaction.lookup.RemoteTransactionManagerLookup;
import org.infinispan.client.hotrod.transaction.manager.RemoteTransactionManager;
import org.infinispan.commons.test.ExceptionRunnable;
import org.infinispan.commons.time.ControlledTimeService;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.tx.TransactionImpl;
import org.infinispan.commons.tx.XidImpl;
import org.infinispan.commons.tx.lookup.TransactionManagerLookup;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.IsolationLevel;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.tx.table.GlobalTxTable;
import org.infinispan.test.TestingUtil;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.lookup.EmbeddedTransactionManagerLookup;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.tx.RecoveryTest")
public class RecoveryTest
extends MultiHotRodServersTest {
    private static final AtomicInteger XID_GENERATOR = new AtomicInteger(1);
    private final ControlledTimeService timeService = new ControlledTimeService();

    private static DummyXid newXid() {
        return new DummyXid((byte)XID_GENERATOR.getAndIncrement());
    }

    private static void assertNoTxException(ExceptionRunnable runnable) throws Exception {
        RecoveryTest.assertXaException(runnable, -4);
    }

    private static void assertInvalidException(ExceptionRunnable runnable) throws Exception {
        RecoveryTest.assertXaException(runnable, -5);
    }

    private static void assertXaException(ExceptionRunnable runnable, int errorCode) throws Exception {
        try {
            runnable.run();
            AssertJUnit.fail();
        }
        catch (XAException e) {
            AssertJUnit.assertEquals((int)errorCode, (int)e.errorCode);
        }
    }

    public void testXaResourceReUse() throws Exception {
        XAResource xaResource = this.xaResource(0);
        DummyXid xid = RecoveryTest.newXid();
        RecoveryTest.assertNoTxException(() -> xaResource.start((Xid)((Object)xid), 0x200000));
        RecoveryTest.assertNoTxException(() -> xaResource.start((Xid)((Object)xid), 0x8000000));
        RecoveryTest.assertNoTxException(() -> xaResource.end((Xid)((Object)xid), 0));
        RecoveryTest.assertNoTxException(() -> xaResource.prepare((Xid)((Object)xid)));
        RecoveryTest.assertNoTxException(() -> xaResource.commit((Xid)((Object)xid), false));
        RecoveryTest.assertNoTxException(() -> xaResource.rollback((Xid)((Object)xid)));
        Xid[] actual = xaResource.recover(0x1000000);
        AssertJUnit.assertEquals((int)0, (int)actual.length);
        actual = xaResource.recover(0);
        AssertJUnit.assertEquals((int)0, (int)actual.length);
        actual = xaResource.recover(0x800000);
        AssertJUnit.assertEquals((int)0, (int)actual.length);
        xaResource.forget((Xid)((Object)xid));
    }

    public void testStartAndFinishScan() throws Exception {
        this.doStartAndFinishScanTest(this::xaResource);
    }

    public void testStartAndFinishScanWithRecoverableXaResource() throws Exception {
        this.doStartAndFinishScanTest(this::recoverableXaResource);
    }

    public void testRecoveryIteration() throws Exception {
        this.doRecoveryIterationTest(this::xaResource);
    }

    public void testRecoveryIterationWithRecoverableXaResource() throws Exception {
        this.doRecoveryIterationTest(this::recoverableXaResource);
    }

    public void testXaResourceEnlistAfterRecoverable(Method method) throws Exception {
        String key = method.getName();
        RemoteCache cache = this.remoteCache(0);
        RemoteTransactionManager tm = this.remoteTM(0);
        tm.begin();
        TransactionImpl tx = (TransactionImpl)tm.getTransaction();
        AssertJUnit.assertEquals((int)0, (int)tx.getEnlistedResources().size());
        tx.enlistResource(this.recoverableXaResource(0));
        AssertJUnit.assertEquals((int)1, (int)tx.getEnlistedResources().size());
        cache.put((Object)key, (Object)"value");
        AssertJUnit.assertEquals((int)2, (int)tx.getEnlistedResources().size());
        tm.suspend();
        AssertJUnit.assertNull((Object)cache.get((Object)key));
        tm.resume((Transaction)tx);
        tm.commit();
        AssertJUnit.assertEquals((String)"value", (String)((String)cache.get((Object)key)));
    }

    public void testRecoverableAfterXaResource(Method method) throws Exception {
        String key = method.getName();
        RemoteCache cache = this.remoteCache(0);
        RemoteTransactionManager tm = this.remoteTM(0);
        tm.begin();
        TransactionImpl tx = (TransactionImpl)tm.getTransaction();
        AssertJUnit.assertEquals((int)0, (int)tx.getEnlistedResources().size());
        cache.put((Object)key, (Object)"value");
        AssertJUnit.assertEquals((int)1, (int)tx.getEnlistedResources().size());
        tx.enlistResource(this.recoverableXaResource(0));
        AssertJUnit.assertEquals((int)2, (int)tx.getEnlistedResources().size());
        tm.commit();
        AssertJUnit.assertEquals((String)"value", (String)((String)cache.get((Object)key)));
    }

    protected String cacheName() {
        return "recovery-test-cache";
    }

    protected void createCacheManagers() throws Throwable {
        org.infinispan.configuration.cache.ConfigurationBuilder cacheBuilder = RecoveryTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)true);
        cacheBuilder.transaction().transactionManagerLookup((TransactionManagerLookup)new EmbeddedTransactionManagerLookup());
        cacheBuilder.transaction().lockingMode(LockingMode.PESSIMISTIC);
        cacheBuilder.locking().isolationLevel(IsolationLevel.REPEATABLE_READ);
        this.createHotRodServers(this.numberOfNodes(), new org.infinispan.configuration.cache.ConfigurationBuilder());
        for (EmbeddedCacheManager cm : this.cacheManagers) {
            TestingUtil.replaceComponent((CacheContainer)cm, TimeService.class, (Object)this.timeService, (boolean)true);
            ((GlobalTxTable)TestingUtil.extractGlobalComponent((CacheContainer)cm, GlobalTxTable.class)).stop();
        }
        this.defineInAll(this.cacheName(), cacheBuilder);
    }

    @Override
    protected ConfigurationBuilder createHotRodClientConfigurationBuilder(String host, int serverPort) {
        ConfigurationBuilder clientBuilder = super.createHotRodClientConfigurationBuilder(host, serverPort);
        clientBuilder.forceReturnValues(false);
        clientBuilder.remoteCache(this.cacheName()).transactionManagerLookup(RemoteTransactionManagerLookup.getInstance()).transactionMode(TransactionMode.FULL_XA);
        clientBuilder.transactionTimeout(10L, TimeUnit.SECONDS);
        return clientBuilder;
    }

    private void doStartAndFinishScanTest(XaResourceSupplier xaResourceSupplier) throws Exception {
        XAResource xaResource = xaResourceSupplier.get(0);
        RecoveryTest.assertInvalidException(() -> xaResource.recover(0x800000));
        xaResource.recover(0x1000000);
        RecoveryTest.assertInvalidException(() -> xaResource.recover(0x1000000));
        xaResource.recover(0x800000);
        xaResource.recover(0x1800000);
        RecoveryTest.assertInvalidException(() -> xaResource.recover(0));
    }

    private void doRecoveryIterationTest(XaResourceSupplier xaResourceSupplier) throws Exception {
        XAResource xaResource0 = xaResourceSupplier.get(0);
        XAResource xaResource1 = xaResourceSupplier.get(1);
        this.remoteTM(0).begin();
        this.remoteCache(0).put((Object)"k0", (Object)"v");
        Xid xid0 = this.xid(0);
        this.prepare(0);
        this.remoteTM(1).begin();
        this.remoteCache(1).put((Object)"k1", (Object)"v");
        Xid xid1 = this.xid(1);
        this.prepare(1);
        this.timeService.advance(9000L);
        this.assertBeforeTimeoutRecoveryIteration(xaResource0, xid0);
        this.assertBeforeTimeoutRecoveryIteration(xaResource1, xid1);
        this.timeService.advance(2000L);
        this.assertRecoveryIteration(xaResource0, xid0, xid1);
        this.assertRecoveryIteration(xaResource1, xid1, xid0);
        xaResource1.commit(xid0, false);
        xaResource1.rollback(xid1);
        AssertJUnit.assertEquals((Object)"v", (Object)this.remoteCache(0).get((Object)"k0"));
        AssertJUnit.assertNull((Object)this.remoteCache(0).get((Object)"k1"));
        xaResource0.forget(xid0);
        xaResource1.forget(xid1);
    }

    private void assertRecoveryIteration(XAResource xaResource, Xid local, Xid remote) throws Exception {
        Xid[] actual = xaResource.recover(0x1000000);
        AssertJUnit.assertTrue((actual.length != 0 ? 1 : 0) != 0);
        if (actual.length == 1) {
            AssertJUnit.assertEquals((Object)local, (Object)actual[0]);
            actual = xaResource.recover(0x800000);
            AssertJUnit.assertEquals((int)1, (int)actual.length);
            AssertJUnit.assertEquals((Object)remote, (Object)actual[0]);
        } else {
            AssertJUnit.assertEquals((Object)local, (Object)actual[0]);
            AssertJUnit.assertEquals((Object)remote, (Object)actual[1]);
            actual = xaResource.recover(0x800000);
            AssertJUnit.assertEquals((int)0, (int)actual.length);
        }
    }

    private void assertBeforeTimeoutRecoveryIteration(XAResource xaResource, Xid local) throws Exception {
        Xid[] actual = xaResource.recover(0x1000000);
        AssertJUnit.assertEquals((int)1, (int)actual.length);
        AssertJUnit.assertEquals((Object)local, (Object)actual[0]);
        actual = xaResource.recover(0x800000);
        AssertJUnit.assertEquals((int)0, (int)actual.length);
    }

    private void prepare(int index) throws Exception {
        RemoteTransactionManager tm = this.remoteTM(index);
        TransactionImpl tx = (TransactionImpl)tm.getTransaction();
        tm.suspend();
        AssertJUnit.assertTrue((boolean)tx.runPrepare());
    }

    private Xid xid(int index) {
        TransactionImpl tx = (TransactionImpl)this.remoteTM(index).getTransaction();
        return tx.getXid();
    }

    private XAResource xaResource(int index) throws Exception {
        RemoteTransactionManager tm = this.remoteTM(index);
        tm.begin();
        RemoteCache cache = this.remoteCache(index);
        cache.put((Object)"_k_", (Object)"_v_");
        TransactionImpl tx = (TransactionImpl)tm.getTransaction();
        XAResource xaResource = (XAResource)tx.getEnlistedResources().iterator().next();
        tm.commit();
        xaResource.forget((Xid)tx.getXid());
        return xaResource;
    }

    private XAResource recoverableXaResource(int index) {
        return this.client(index).getXaResource();
    }

    private <K, V> RemoteCache<K, V> remoteCache(int index) {
        return this.client(index).getCache(this.cacheName());
    }

    private RemoteTransactionManager remoteTM(int index) {
        return (RemoteTransactionManager)this.remoteCache(index).getTransactionManager();
    }

    private int numberOfNodes() {
        return 3;
    }

    private static class DummyXid
    extends XidImpl {
        DummyXid(byte id) {
            super(-1234, new byte[]{id}, new byte[]{id});
        }
    }

    @FunctionalInterface
    private static interface XaResourceSupplier {
        public XAResource get(int var1) throws Exception;
    }
}

