/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.xsite;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.infinispan.client.hotrod.CacheTopologyInfo;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.configuration.ClientIntelligence;
import org.infinispan.client.hotrod.configuration.ClusterConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.ServerConfigurationBuilder;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelFactory;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.client.hotrod.test.InternalRemoteCacheManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.xsite.AbstractMultipleSitesTest;
import org.infinispan.xsite.AbstractXSiteTest;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.xsite.ClientIntelligenceClusterTest")
public class ClientIntelligenceClusterTest
extends AbstractMultipleSitesTest {
    private final Map<String, List<HotRodServer>> siteServers = new HashMap<String, List<HotRodServer>>(this.defaultNumberOfSites());

    protected void afterSitesCreated() {
        super.afterSitesCreated();
        for (AbstractXSiteTest.TestSite site : this.sites) {
            this.siteServers.put(site.getSiteName(), site.cacheManagers().stream().map(HotRodClientTestingUtil::startHotRodServer).collect(Collectors.toList()));
        }
    }

    protected void killSites() {
        this.siteServers.values().forEach(hotRodServers -> hotRodServers.forEach(xva$0 -> HotRodClientTestingUtil.killServers(xva$0)));
        this.siteServers.clear();
        super.killSites();
    }

    public void testClusterInheritsIntelligence() {
        try (InternalRemoteCacheManager irc = this.createClient(ClientIntelligence.BASIC, null);){
            RemoteCache cache0 = irc.getCache();
            byte[] cacheNameBytes = cache0.getName().getBytes();
            cache0.put((Object)"key", (Object)"value");
            AssertJUnit.assertEquals((String)"value", (String)((String)cache0.get((Object)"key")));
            ClientIntelligenceClusterTest.assertBasicIntelligence(irc, cacheNameBytes);
            irc.switchToCluster("backup");
            cache0.put((Object)"key1", (Object)"value1");
            AssertJUnit.assertEquals((String)"value1", (String)((String)cache0.get((Object)"key1")));
            ClientIntelligenceClusterTest.assertBasicIntelligence(irc, cacheNameBytes);
            irc.switchToDefaultCluster();
            cache0.put((Object)"key2", (Object)"value2");
            AssertJUnit.assertEquals((String)"value2", (String)((String)cache0.get((Object)"key2")));
            ClientIntelligenceClusterTest.assertBasicIntelligence(irc, cacheNameBytes);
        }
    }

    public void testBackupClusterUsesBasicIntelligence() {
        try (InternalRemoteCacheManager irc = this.createClient(ClientIntelligence.HASH_DISTRIBUTION_AWARE, ClientIntelligence.BASIC);){
            RemoteCache cache0 = irc.getCache();
            byte[] cacheNameBytes = cache0.getName().getBytes();
            cache0.put((Object)"key", (Object)"value");
            AssertJUnit.assertEquals((String)"value", (String)((String)cache0.get((Object)"key")));
            ClientIntelligenceClusterTest.assertHashAwareIntelligence(irc, cacheNameBytes);
            irc.switchToCluster("backup");
            cache0.put((Object)"key1", (Object)"value1");
            AssertJUnit.assertEquals((String)"value1", (String)((String)cache0.get((Object)"key1")));
            ClientIntelligenceClusterTest.assertBasicIntelligence(irc, cacheNameBytes);
            irc.switchToDefaultCluster();
            cache0.put((Object)"key2", (Object)"value2");
            AssertJUnit.assertEquals((String)"value2", (String)((String)cache0.get((Object)"key2")));
            ClientIntelligenceClusterTest.assertHashAwareIntelligence(irc, cacheNameBytes);
        }
    }

    public void testBackupClusterUsesTopologyIntelligence() {
        try (InternalRemoteCacheManager irc = this.createClient(ClientIntelligence.BASIC, ClientIntelligence.TOPOLOGY_AWARE);){
            RemoteCache cache0 = irc.getCache();
            byte[] cacheNameBytes = cache0.getName().getBytes();
            cache0.put((Object)"key", (Object)"value");
            AssertJUnit.assertEquals((String)"value", (String)((String)cache0.get((Object)"key")));
            ClientIntelligenceClusterTest.assertBasicIntelligence(irc, cacheNameBytes);
            irc.switchToCluster("backup");
            cache0.put((Object)"key1", (Object)"value1");
            AssertJUnit.assertEquals((String)"value1", (String)((String)cache0.get((Object)"key1")));
            ClientIntelligenceClusterTest.assertTopologyAwareIntelligence(irc, cacheNameBytes);
            irc.switchToDefaultCluster();
            cache0.put((Object)"key2", (Object)"value2");
            AssertJUnit.assertEquals((String)"value2", (String)((String)cache0.get((Object)"key2")));
            ClientIntelligenceClusterTest.assertBasicIntelligence(irc, cacheNameBytes);
        }
    }

    private InternalRemoteCacheManager createClient(ClientIntelligence globalIntelligence, ClientIntelligence backupIntelligence) {
        ConfigurationBuilder builder = HotRodClientTestingUtil.newRemoteConfigurationBuilder();
        if (globalIntelligence != null) {
            builder.clientIntelligence(globalIntelligence);
        }
        this.addServer(builder.addServer(), this.siteName(0));
        this.addServer(builder.addCluster("backup").clusterClientIntelligence(backupIntelligence), this.siteName(1));
        return new InternalRemoteCacheManager(builder.build());
    }

    private HotRodServer getFirstServer(String siteName) {
        return this.siteServers.get(siteName).get(0);
    }

    private void addServer(ServerConfigurationBuilder builder, String siteName) {
        HotRodServer server = this.getFirstServer(siteName);
        builder.host(server.getHost()).port(server.getPort().intValue());
    }

    private void addServer(ClusterConfigurationBuilder builder, String siteName) {
        HotRodServer server = this.getFirstServer(siteName);
        builder.addClusterNode(server.getHost(), server.getPort().intValue());
    }

    private static void assertHashAwareIntelligence(InternalRemoteCacheManager ircm, byte[] cacheNameBytes) {
        ChannelFactory factory = ircm.getChannelFactory();
        log.debugf("Server list: %s", (Object)factory.getServers(cacheNameBytes));
        log.debugf("Topology Info: %s", (Object)factory.getCacheTopologyInfo(cacheNameBytes));
        log.debugf("Consistent Hash: %s", (Object)factory.getConsistentHash(cacheNameBytes));
        AssertJUnit.assertEquals((int)2, (int)factory.getServers(cacheNameBytes).size());
        CacheTopologyInfo topologyInfo = factory.getCacheTopologyInfo(cacheNameBytes);
        AssertJUnit.assertNotNull((Object)topologyInfo);
        AssertJUnit.assertEquals((int)2, (int)topologyInfo.getSegmentsPerServer().size());
        AssertJUnit.assertNotNull((Object)topologyInfo.getNumSegments());
        AssertJUnit.assertNotNull((Object)factory.getConsistentHash(cacheNameBytes));
    }

    private static void assertTopologyAwareIntelligence(InternalRemoteCacheManager ircm, byte[] cacheNameBytes) {
        ChannelFactory factory = ircm.getChannelFactory();
        log.debugf("Server list: %s", (Object)factory.getServers(cacheNameBytes));
        log.debugf("Topology Info: %s", (Object)factory.getCacheTopologyInfo(cacheNameBytes));
        log.debugf("Consistent Hash: %s", (Object)factory.getConsistentHash(cacheNameBytes));
        AssertJUnit.assertEquals((int)2, (int)factory.getServers(cacheNameBytes).size());
        CacheTopologyInfo topologyInfo = factory.getCacheTopologyInfo(cacheNameBytes);
        AssertJUnit.assertNotNull((Object)topologyInfo);
        AssertJUnit.assertEquals((int)2, (int)topologyInfo.getSegmentsPerServer().size());
        AssertJUnit.assertNull((Object)topologyInfo.getNumSegments());
        AssertJUnit.assertNull((Object)factory.getConsistentHash(cacheNameBytes));
    }

    private static void assertBasicIntelligence(InternalRemoteCacheManager ircm, byte[] cacheNameBytes) {
        ChannelFactory factory = ircm.getChannelFactory();
        log.debugf("Server list: %s", (Object)factory.getServers(cacheNameBytes));
        log.debugf("Topology Info: %s", (Object)factory.getCacheTopologyInfo(cacheNameBytes));
        log.debugf("Consistent Hash: %s", (Object)factory.getConsistentHash(cacheNameBytes));
        AssertJUnit.assertEquals((int)1, (int)factory.getServers(cacheNameBytes).size());
        CacheTopologyInfo topologyInfo = factory.getCacheTopologyInfo(cacheNameBytes);
        AssertJUnit.assertNotNull((Object)topologyInfo);
        AssertJUnit.assertEquals((int)1, (int)topologyInfo.getSegmentsPerServer().size());
        AssertJUnit.assertNull((Object)topologyInfo.getNumSegments());
        AssertJUnit.assertNull((Object)factory.getConsistentHash(cacheNameBytes));
    }
}

