/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.protocol;

import io.netty.buffer.ByteBuf;
import java.util.Map;
import org.infinispan.client.hotrod.DataFormat;
import org.infinispan.client.hotrod.MetadataValue;
import org.infinispan.client.hotrod.impl.operations.GetWithMetadataOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec31;
import org.infinispan.client.hotrod.impl.protocol.HeaderParams;
import org.infinispan.client.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.client.hotrod.impl.transport.netty.ByteBufUtil;
import org.infinispan.commons.configuration.ClassAllowList;
import org.infinispan.commons.marshall.Marshaller;

public class Codec40
extends Codec31 {
    @Override
    public HeaderParams writeHeader(ByteBuf buf, HeaderParams params) {
        return this.writeHeader(buf, params, (byte)40);
    }

    @Override
    public Object returnPossiblePrevValue(ByteBuf buf, short status, DataFormat dataFormat, int flags, ClassAllowList allowList, Marshaller marshaller) {
        if (HotRodConstants.hasPrevious(status)) {
            MetadataValue metadataValue = GetWithMetadataOperation.readMetadataValue(buf, status, dataFormat, allowList);
            return metadataValue != null ? metadataValue.getValue() : null;
        }
        return null;
    }

    @Override
    protected HeaderParams writeHeader(ByteBuf buf, HeaderParams params, byte version) {
        HeaderParams headerParams = super.writeHeader(buf, params, version);
        this.writeOtherParams(buf, params.otherParams());
        return headerParams;
    }

    private void writeOtherParams(ByteBuf buf, Map<String, byte[]> parameters) {
        if (parameters == null) {
            ByteBufUtil.writeVInt(buf, 0);
            return;
        }
        ByteBufUtil.writeVInt(buf, parameters.size());
        parameters.forEach((key, value) -> {
            ByteBufUtil.writeString(buf, key);
            ByteBufUtil.writeArray(buf, value);
        });
    }

    @Override
    public int estimateSizeMultimapSupportsDuplicated() {
        return 1;
    }

    @Override
    public void writeMultimapSupportDuplicates(ByteBuf buf, boolean supportsDuplicates) {
        buf.writeByte(supportsDuplicates ? 1 : 0);
    }

    @Override
    public boolean isUnsafeForTheHandshake() {
        return true;
    }
}

