/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.infinispan.api.Experimental;
import org.infinispan.api.async.AsyncCache;
import org.infinispan.api.async.AsyncCaches;
import org.infinispan.api.configuration.CacheConfiguration;
import org.infinispan.client.hotrod.HotRod;
import org.infinispan.client.hotrod.HotRodAsyncCache;
import org.infinispan.client.hotrod.impl.InternalRemoteCache;
import org.infinispan.commons.util.concurrent.CompletableFutures;

@Experimental
final class HotRodAsyncCaches
implements AsyncCaches {
    private final HotRod hotrod;

    HotRodAsyncCaches(HotRod hotrod) {
        this.hotrod = hotrod;
    }

    public <K, V> CompletionStage<AsyncCache<K, V>> get(String name) {
        InternalRemoteCache<K, V> cache = this.getCache(name);
        return CompletableFuture.completedFuture(new HotRodAsyncCache<K, V>(this.hotrod, cache));
    }

    public <K, V> CompletionStage<AsyncCache<K, V>> create(String name, CacheConfiguration cacheConfiguration) {
        this.hotrod.cacheManager.getConfiguration().addRemoteCache(name, builder -> builder.configuration(cacheConfiguration.toString()));
        return this.get(name);
    }

    public <K, V> CompletionStage<AsyncCache<K, V>> create(String name, String template) {
        throw new UnsupportedOperationException();
    }

    public CompletionStage<Void> remove(String name) {
        this.hotrod.cacheManager.administration().removeCache(name);
        return CompletableFutures.completedNull();
    }

    public CompletionStage<Set<String>> names() {
        return CompletableFuture.completedFuture(this.hotrod.cacheManager.getCacheNames());
    }

    public CompletionStage<Void> createTemplate(String name, CacheConfiguration cacheConfiguration) {
        throw new UnsupportedOperationException();
    }

    public CompletionStage<Void> removeTemplate(String name) {
        throw new UnsupportedOperationException();
    }

    public CompletionStage<Set<String>> templateNames() {
        throw new UnsupportedOperationException();
    }

    private <K, V> InternalRemoteCache<K, V> getCache(String name) {
        return (InternalRemoteCache)this.hotrod.cacheManager.getCache(name);
    }
}

