/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.protocol;

import io.netty.buffer.ByteBuf;
import java.lang.annotation.Annotation;
import java.net.SocketAddress;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.infinispan.client.hotrod.DataFormat;
import org.infinispan.client.hotrod.MetadataValue;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryCreated;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryExpired;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryModified;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryRemoved;
import org.infinispan.client.hotrod.annotation.ClientListener;
import org.infinispan.client.hotrod.counter.impl.HotRodCounterEvent;
import org.infinispan.client.hotrod.event.ClientEvent;
import org.infinispan.client.hotrod.event.impl.AbstractClientEvent;
import org.infinispan.client.hotrod.event.impl.CreatedEventImpl;
import org.infinispan.client.hotrod.event.impl.CustomEventImpl;
import org.infinispan.client.hotrod.event.impl.ExpiredEventImpl;
import org.infinispan.client.hotrod.event.impl.ModifiedEventImpl;
import org.infinispan.client.hotrod.event.impl.RemovedEventImpl;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.exceptions.RemoteIllegalLifecycleStateException;
import org.infinispan.client.hotrod.exceptions.RemoteNodeSuspectException;
import org.infinispan.client.hotrod.impl.ClientTopology;
import org.infinispan.client.hotrod.impl.MetadataValueImpl;
import org.infinispan.client.hotrod.impl.TimeUnitParam;
import org.infinispan.client.hotrod.impl.operations.CacheUnmarshaller;
import org.infinispan.client.hotrod.impl.operations.HotRodOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.client.hotrod.impl.transport.netty.ByteBufUtil;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.commons.configuration.ClassAllowList;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.MediaTypeIds;
import org.infinispan.commons.util.IntSet;
import org.infinispan.counter.api.CounterState;

public class Codec30
implements Codec {
    static final Log log = LogFactory.getLog(Codec.class, Log.class);
    public static final String EMPTY_VALUE_CONVERTER = "org.infinispan.server.hotrod.HotRodServer$ToEmptyBytesKeyValueFilterConverter";

    @Override
    public void writeBloomFilter(ByteBuf buf, int bloomFilterBits) {
        if (bloomFilterBits > 0) {
            throw new UnsupportedOperationException("Bloom Filter optimization is not available for versions before 3.1");
        }
    }

    @Override
    public long readMessageId(ByteBuf buf) {
        short magic = buf.readUnsignedByte();
        if (magic != 161) {
            if (log.isTraceEnabled()) {
                log.tracef("Socket dump: %s", ByteBufUtil.limitedHexDump(buf));
            }
            throw Log.HOTROD.invalidMagicNumber((short)161, magic);
        }
        return ByteBufUtil.readVLong(buf);
    }

    @Override
    public void writeHeader(ByteBuf buf, long messageId, ClientTopology clientTopology, HotRodOperation<?> operation) {
        this.writeHeader(buf, messageId, clientTopology, operation, (byte)30);
    }

    protected void writeHeader(ByteBuf buf, long messageId, ClientTopology clientTopology, HotRodOperation<?> operation, byte version) {
        buf.writeByte(160);
        ByteBufUtil.writeVLong(buf, messageId);
        buf.writeByte((int)version);
        buf.writeByte((int)operation.requestOpCode());
        ByteBufUtil.writeArray(buf, operation.getCacheNameBytes());
        ByteBufUtil.writeVInt(buf, operation.flags());
        buf.writeByte((int)clientTopology.getClientIntelligence().getValue());
        ByteBufUtil.writeVInt(buf, clientTopology.getTopologyId());
        this.writeDataTypes(buf, operation.getDataFormat());
        if (log.isTraceEnabled()) {
            log.tracef("[%s] Wrote header for messageId=%d. Operation code: %#04x(%s). Flags: %#x. Topology id: %s", new Object[]{operation.getCacheName(), messageId, operation.requestOpCode(), HotRodConstants.Names.of(operation.requestOpCode()), operation.flags(), clientTopology.getTopologyId()});
        }
    }

    @Override
    public HotRodCounterEvent readCounterEvent(ByteBuf buf) {
        short status = buf.readByte();
        assert (status == 0);
        short topology = buf.readByte();
        assert (topology == 0);
        String counterName = ByteBufUtil.readString(buf);
        byte[] listenerId = ByteBufUtil.readArray(buf);
        short encodedCounterState = buf.readByte();
        long oldValue = buf.readLong();
        long newValue = buf.readLong();
        return new HotRodCounterEvent(listenerId, counterName, oldValue, Codec30.decodeOldState(encodedCounterState), newValue, Codec30.decodeNewState(encodedCounterState));
    }

    private static CounterState decodeOldState(short encoded) {
        return switch (encoded & 3) {
            case 0 -> CounterState.VALID;
            case 1 -> CounterState.LOWER_BOUND_REACHED;
            case 2 -> CounterState.UPPER_BOUND_REACHED;
            default -> throw new IllegalStateException();
        };
    }

    private static CounterState decodeNewState(short encoded) {
        return switch (encoded & 0xC) {
            case 0 -> CounterState.VALID;
            case 4 -> CounterState.LOWER_BOUND_REACHED;
            case 8 -> CounterState.UPPER_BOUND_REACHED;
            default -> throw new IllegalStateException();
        };
    }

    @Override
    public void writeMultimapSupportDuplicates(ByteBuf buf, boolean supportsDuplicates) {
    }

    @Override
    public Object returnPossiblePrevValue(ByteBuf buf, short status, CacheUnmarshaller unmarshaller) {
        if (HotRodConstants.hasPrevious(status)) {
            return unmarshaller.readValue(buf);
        }
        return null;
    }

    @Override
    public <V> MetadataValue<V> returnMetadataValue(ByteBuf buf, short status, CacheUnmarshaller unmarshaller) {
        if (!HotRodConstants.hasPrevious(status)) {
            return null;
        }
        Object value = unmarshaller.readValue(buf);
        return new MetadataValueImpl(-1L, -1, -1L, -1, 0L, value);
    }

    protected AbstractClientEvent createRemovedEvent(byte[] listenerId, Object key, boolean isRetried) {
        return new RemovedEventImpl<Object>(listenerId, key, isRetried);
    }

    protected AbstractClientEvent createModifiedEvent(byte[] listenerId, Object key, long dataVersion, boolean isRetried) {
        return new ModifiedEventImpl<Object>(listenerId, key, dataVersion, isRetried);
    }

    protected AbstractClientEvent createCreatedEvent(byte[] listenerId, Object key, long dataVersion, boolean isRetried) {
        return new CreatedEventImpl<Object>(listenerId, key, dataVersion, isRetried);
    }

    protected AbstractClientEvent createCustomEvent(byte[] listenerId, Object eventData, ClientEvent.Type eventType, boolean isRetried) {
        return new CustomEventImpl<Object>(listenerId, eventData, isRetried, eventType);
    }

    @Override
    public void checkForErrorsInResponseStatus(ByteBuf buf, String cacheName, long messageId, short status, SocketAddress serverAddress) {
        if (log.isTraceEnabled()) {
            log.tracef("[%s] Received operation status: %#x", cacheName, status);
        }
        try {
            switch (status) {
                case 129: 
                case 130: 
                case 131: 
                case 132: 
                case 133: 
                case 134: {
                    String msgFromServer = ByteBufUtil.readString(buf);
                    if (status == 134 && log.isTraceEnabled()) {
                        log.tracef("Server-side timeout performing operation: %s", msgFromServer);
                    } else {
                        Log.HOTROD.errorFromServer(msgFromServer);
                    }
                    throw new HotRodClientException(msgFromServer, messageId, status);
                }
                case 136: {
                    String msgFromServer = ByteBufUtil.readString(buf);
                    throw new RemoteIllegalLifecycleStateException(msgFromServer, messageId, status, serverAddress);
                }
                case 135: {
                    String msgFromServer = ByteBufUtil.readString(buf);
                    if (log.isTraceEnabled()) {
                        log.tracef("[%s] A remote node was suspected while executing messageId=%d. Check if retry possible. Message from server: %s", cacheName, messageId, msgFromServer);
                    }
                    throw new RemoteNodeSuspectException(msgFromServer, messageId, status);
                }
            }
            throw new IllegalStateException(String.format("Unknown status: %#04x", status));
        }
        catch (Throwable throwable) {
            switch (status) {
                default: 
            }
            throw throwable;
        }
    }

    @Override
    public void writeClientListenerParams(ByteBuf buf, ClientListener clientListener, byte[][] filterFactoryParams, byte[][] converterFactoryParams) {
        buf.writeByte((int)((short)(clientListener.includeCurrentState() ? 1 : 0)));
        this.writeNamedFactory(buf, clientListener.filterFactoryName(), filterFactoryParams);
        this.writeNamedFactory(buf, clientListener.converterFactoryName(), converterFactoryParams);
        buf.writeByte((int)((short)(clientListener.useRawData() ? 1 : 0)));
    }

    private void writeNamedFactory(ByteBuf buf, String factoryName, byte[][] params) {
        ByteBufUtil.writeString(buf, factoryName);
        if (!factoryName.isEmpty()) {
            if (params != null) {
                buf.writeByte((int)((short)params.length));
                for (byte[] param : params) {
                    ByteBufUtil.writeArray(buf, param);
                }
            } else {
                buf.writeByte(0);
            }
        }
    }

    @Override
    public AbstractClientEvent readCacheEvent(ByteBuf buf, long messageId, Function<byte[], DataFormat> listenerDataFormat, short eventTypeId, ClassAllowList allowList, SocketAddress serverAddress) {
        ClientEvent.Type eventType;
        short status = buf.readUnsignedByte();
        buf.readUnsignedByte();
        switch (eventTypeId) {
            case 96: {
                eventType = ClientEvent.Type.CLIENT_CACHE_ENTRY_CREATED;
                break;
            }
            case 97: {
                eventType = ClientEvent.Type.CLIENT_CACHE_ENTRY_MODIFIED;
                break;
            }
            case 98: {
                eventType = ClientEvent.Type.CLIENT_CACHE_ENTRY_REMOVED;
                break;
            }
            case 99: {
                eventType = ClientEvent.Type.CLIENT_CACHE_ENTRY_EXPIRED;
                break;
            }
            case 80: {
                this.checkForErrorsInResponseStatus(buf, null, messageId, status, serverAddress);
            }
            default: {
                throw Log.HOTROD.unknownEvent(eventTypeId);
            }
        }
        byte[] listenerId = ByteBufUtil.readArray(buf);
        short isCustom = buf.readUnsignedByte();
        boolean isRetried = buf.readUnsignedByte() == 1;
        DataFormat dataFormat = listenerDataFormat.apply(listenerId);
        if (isCustom == 1) {
            Object eventData = dataFormat.valueToObj(ByteBufUtil.readArray(buf), allowList);
            return this.createCustomEvent(listenerId, eventData, eventType, isRetried);
        }
        if (isCustom == 2) {
            return this.createCustomEvent(listenerId, ByteBufUtil.readArray(buf), eventType, isRetried);
        }
        switch (eventType) {
            case CLIENT_CACHE_ENTRY_CREATED: {
                Object createdKey = dataFormat.keyToObj(ByteBufUtil.readArray(buf), allowList);
                long createdDataVersion = buf.readLong();
                return this.createCreatedEvent(listenerId, createdKey, createdDataVersion, isRetried);
            }
            case CLIENT_CACHE_ENTRY_MODIFIED: {
                Object modifiedKey = dataFormat.keyToObj(ByteBufUtil.readArray(buf), allowList);
                long modifiedDataVersion = buf.readLong();
                return this.createModifiedEvent(listenerId, modifiedKey, modifiedDataVersion, isRetried);
            }
            case CLIENT_CACHE_ENTRY_REMOVED: {
                Object removedKey = dataFormat.keyToObj(ByteBufUtil.readArray(buf), allowList);
                return this.createRemovedEvent(listenerId, removedKey, isRetried);
            }
            case CLIENT_CACHE_ENTRY_EXPIRED: {
                Object expiredKey = dataFormat.keyToObj(ByteBufUtil.readArray(buf), allowList);
                return this.createExpiredEvent(listenerId, expiredKey);
            }
        }
        throw Log.HOTROD.unknownEvent(eventTypeId);
    }

    protected AbstractClientEvent createExpiredEvent(byte[] listenerId, Object key) {
        return new ExpiredEventImpl<Object>(listenerId, key);
    }

    @Override
    public void writeExpirationParams(ByteBuf buf, long lifespan, TimeUnit lifespanTimeUnit, long maxIdle, TimeUnit maxIdleTimeUnit) {
        byte timeUnits = TimeUnitParam.encodeTimeUnits(lifespan, lifespanTimeUnit, maxIdle, maxIdleTimeUnit);
        buf.writeByte((int)timeUnits);
        if (lifespan > 0L) {
            ByteBufUtil.writeVLong(buf, lifespan);
        }
        if (maxIdle > 0L) {
            ByteBufUtil.writeVLong(buf, maxIdle);
        }
    }

    @Override
    public int estimateExpirationSize(long lifespan, TimeUnit lifespanTimeUnit, long maxIdle, TimeUnit maxIdleTimeUnit) {
        return 1 + (lifespan > 0L ? ByteBufUtil.estimateVLongSize(lifespan) : 0) + (lifespan > 0L ? ByteBufUtil.estimateVLongSize(maxIdle) : 0);
    }

    @Override
    public void writeIteratorStartOperation(ByteBuf buf, IntSet segments, String filterConverterFactory, int batchSize, boolean metadata, byte[][] filterParameters) {
        if (segments == null) {
            ByteBufUtil.writeSignedVInt(buf, -1);
        } else {
            BitSet bitSet = new BitSet();
            segments.forEach(bitSet::set);
            ByteBufUtil.writeOptionalArray(buf, bitSet.toByteArray());
        }
        ByteBufUtil.writeOptionalString(buf, filterConverterFactory);
        if (filterConverterFactory != null) {
            if (filterParameters != null && filterParameters.length > 0) {
                buf.writeByte(filterParameters.length);
                Arrays.stream(filterParameters).forEach(param -> ByteBufUtil.writeArray(buf, param));
            } else {
                buf.writeByte(0);
            }
        }
        ByteBufUtil.writeVInt(buf, batchSize);
        buf.writeByte(metadata ? 1 : 0);
    }

    @Override
    public void writeClientListenerInterests(ByteBuf buf, Set<Class<? extends Annotation>> classes) {
        byte listenerInterests = 0;
        if (classes.contains(ClientCacheEntryCreated.class)) {
            listenerInterests = (byte)(listenerInterests | 1);
        }
        if (classes.contains(ClientCacheEntryModified.class)) {
            listenerInterests = (byte)(listenerInterests | 2);
        }
        if (classes.contains(ClientCacheEntryRemoved.class)) {
            listenerInterests = (byte)(listenerInterests | 4);
        }
        if (classes.contains(ClientCacheEntryExpired.class)) {
            listenerInterests = (byte)(listenerInterests | 8);
        }
        ByteBufUtil.writeVInt(buf, listenerInterests);
    }

    protected void writeDataTypes(ByteBuf buf, DataFormat dataFormat) {
        MediaType keyType = null;
        MediaType valueType = null;
        if (dataFormat != null) {
            keyType = dataFormat.getKeyType();
            valueType = dataFormat.getValueType();
        }
        this.writeMediaType(buf, keyType);
        this.writeMediaType(buf, valueType);
    }

    private void writeMediaType(ByteBuf buf, MediaType mediaType) {
        if (mediaType == null) {
            buf.writeByte(0);
        } else {
            Short id = MediaTypeIds.getId((MediaType)mediaType);
            if (id != null) {
                buf.writeByte(1);
                ByteBufUtil.writeVInt(buf, id.shortValue());
            } else {
                buf.writeByte(2);
                ByteBufUtil.writeString(buf, mediaType.toString());
            }
            Map parameters = mediaType.getParameters();
            ByteBufUtil.writeVInt(buf, parameters.size());
            if (!parameters.isEmpty()) {
                parameters.forEach((key, value) -> {
                    ByteBufUtil.writeString(buf, key);
                    ByteBufUtil.writeString(buf, value);
                });
            }
        }
    }
}

