/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.metrics.micrometer;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.FunctionTimer;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.TimeGauge;
import io.micrometer.core.instrument.Timer;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.infinispan.client.hotrod.metrics.HotRodClientMetricsRegistry;
import org.infinispan.commons.stat.CounterTracker;
import org.infinispan.commons.stat.DistributionSummaryTracker;
import org.infinispan.commons.stat.SimpleTimerTracker;
import org.infinispan.commons.stat.TimerTracker;
import org.infinispan.commons.stat.micrometer.MicrometerCounterTracker;
import org.infinispan.commons.stat.micrometer.MicrometerDistributionSummary;
import org.infinispan.commons.stat.micrometer.MicrometerTimerTracker;

class MicrometerHotRodClientMetricRegistry
implements HotRodClientMetricsRegistry {
    private final MeterRegistry registry;
    private final List<Tag> globalTags;
    private final String prefix;
    private final boolean histogramEnabled;
    private final Set<Meter.Id> ids;

    MicrometerHotRodClientMetricRegistry(MeterRegistry registry, Map<String, String> globalTags, String prefix, boolean histogramEnabled) {
        this.registry = Objects.requireNonNull(registry);
        this.globalTags = globalTags == null ? List.of() : MicrometerHotRodClientMetricRegistry.mapToTag(globalTags).toList();
        this.prefix = prefix;
        this.histogramEnabled = histogramEnabled;
        this.ids = ConcurrentHashMap.newKeySet();
    }

    @Override
    public void createGauge(String metricName, String description, Supplier<Number> gauge, Map<String, String> tags, Consumer<Object> generatedId) {
        Meter.Id id = Gauge.builder((String)this.computeMetricName(metricName), gauge).strongReference(true).tags(this.createTags(tags)).description(description).register(this.registry).getId();
        this.trackMeterId(id, generatedId);
    }

    @Override
    public void createTimeGauge(String metricName, String description, Supplier<Number> gauge, TimeUnit timeUnit, Map<String, String> tags, Consumer<Object> generatedId) {
        Meter.Id id = TimeGauge.builder((String)this.computeMetricName(metricName), gauge, (TimeUnit)timeUnit).strongReference(true).tags(this.createTags(tags)).description(description).register(this.registry).getId();
        this.trackMeterId(id, generatedId);
    }

    @Override
    public TimerTracker createTimer(String metricName, String description, Map<String, String> tags, Consumer<Object> generatedId) {
        if (this.histogramEnabled) {
            Timer timer = Timer.builder((String)this.computeMetricName(metricName)).description(description).publishPercentileHistogram(Boolean.valueOf(true)).tags(this.createTags(tags)).register(this.registry);
            this.trackMeterId(timer.getId(), generatedId);
            return new MicrometerTimerTracker(timer);
        }
        SimpleTimerTracker simpleTimer = new SimpleTimerTracker();
        Meter.Id id = FunctionTimer.builder((String)this.computeMetricName(metricName), (Object)simpleTimer, SimpleTimerTracker::count, SimpleTimerTracker::totalTime, (TimeUnit)TimeUnit.NANOSECONDS).description(description).tags(this.createTags(tags)).register(this.registry).getId();
        this.trackMeterId(id, generatedId);
        return simpleTimer;
    }

    @Override
    public CounterTracker createCounter(String metricName, String description, Map<String, String> tags, Consumer<Object> generatedId) {
        Counter counter = Counter.builder((String)this.computeMetricName(metricName)).description(description).tags(this.createTags(tags)).register(this.registry);
        this.trackMeterId(counter.getId(), generatedId);
        return new MicrometerCounterTracker(counter);
    }

    @Override
    public DistributionSummaryTracker createDistributionSummery(String metricName, String description, Map<String, String> tags, Consumer<Object> generatedId) {
        if (this.histogramEnabled) {
            DistributionSummary summary = DistributionSummary.builder((String)this.computeMetricName(metricName)).description(description).publishPercentileHistogram(Boolean.valueOf(true)).tags(this.createTags(tags)).register(this.registry);
            this.trackMeterId(summary.getId(), generatedId);
            return new MicrometerDistributionSummary(summary);
        }
        return DistributionSummaryTracker.NO_OP;
    }

    @Override
    public void close() {
        this.ids.forEach(arg_0 -> ((MeterRegistry)this.registry).remove(arg_0));
        this.ids.clear();
    }

    @Override
    public void removeMetric(Object id) {
        if (id instanceof Meter.Id) {
            Meter.Id mid = (Meter.Id)id;
            this.registry.remove(mid);
            this.ids.remove(mid);
        }
    }

    MeterRegistry getRegistry() {
        return this.registry;
    }

    boolean isHistogramEnabled() {
        return this.histogramEnabled;
    }

    public String getPrefix() {
        return this.prefix;
    }

    private String computeMetricName(String metricName) {
        String safeMetricName = MicrometerHotRodClientMetricRegistry.decamelize(metricName);
        if (this.prefix == null || this.prefix.isEmpty()) {
            return "vendor.%s".formatted(safeMetricName);
        }
        return "vendor.%s.%s".formatted(this.prefix, safeMetricName);
    }

    private Iterable<Tag> createTags(Map<String, String> metricTags) {
        if (this.globalTags.isEmpty() && metricTags.isEmpty()) {
            return List.of();
        }
        if (metricTags.isEmpty()) {
            return this.globalTags;
        }
        if (this.globalTags.isEmpty()) {
            return () -> MicrometerHotRodClientMetricRegistry.mapToTag(metricTags).iterator();
        }
        return () -> Stream.concat(this.globalTags.stream(), MicrometerHotRodClientMetricRegistry.mapToTag(metricTags)).distinct().iterator();
    }

    private void trackMeterId(Meter.Id id, Consumer<Object> generatedIdConsumer) {
        this.ids.add(id);
        if (generatedIdConsumer != null) {
            generatedIdConsumer.accept(id);
        }
    }

    public static String filterIllegalChars(String name) {
        return name.replaceAll("\\W+", "_");
    }

    public static String decamelize(String name) {
        StringBuilder sb = new StringBuilder(name);
        for (int i = 1; i < sb.length(); ++i) {
            if (!Character.isUpperCase(sb.charAt(i))) continue;
            sb.insert(i++, '_');
            while (i < sb.length() && Character.isUpperCase(sb.charAt(i))) {
                ++i;
            }
        }
        return MicrometerHotRodClientMetricRegistry.filterIllegalChars(sb.toString().toLowerCase()).replaceAll("_+", "_");
    }

    private static Stream<Tag> mapToTag(Map<String, String> tags) {
        return tags.entrySet().stream().map(e -> Tag.of((String)((String)e.getKey()), (String)((String)e.getValue())));
    }
}

