/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import java.util.concurrent.atomic.AtomicInteger;
import net.jcip.annotations.Immutable;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.impl.operations.BulkGetOperation;
import org.infinispan.client.hotrod.impl.operations.ClearOperation;
import org.infinispan.client.hotrod.impl.operations.ContainsKeyOperation;
import org.infinispan.client.hotrod.impl.operations.GetOperation;
import org.infinispan.client.hotrod.impl.operations.GetWithVersionOperation;
import org.infinispan.client.hotrod.impl.operations.PingOperation;
import org.infinispan.client.hotrod.impl.operations.PutIfAbsentOperation;
import org.infinispan.client.hotrod.impl.operations.PutOperation;
import org.infinispan.client.hotrod.impl.operations.RemoveIfUnmodifiedOperation;
import org.infinispan.client.hotrod.impl.operations.RemoveOperation;
import org.infinispan.client.hotrod.impl.operations.ReplaceIfUnmodifiedOperation;
import org.infinispan.client.hotrod.impl.operations.ReplaceOperation;
import org.infinispan.client.hotrod.impl.operations.StatsOperation;
import org.infinispan.client.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.client.hotrod.impl.transport.Transport;
import org.infinispan.client.hotrod.impl.transport.TransportFactory;

@Immutable
public class OperationsFactory
implements HotRodConstants {
    private static final Flag[] FORCE_RETURN_VALUE = new Flag[]{Flag.FORCE_RETURN_VALUE};
    private final ThreadLocal<Flag[]> flagsMap = new ThreadLocal();
    private final TransportFactory transportFactory;
    private final byte[] cacheNameBytes;
    private final AtomicInteger topologyId;
    private final boolean forceReturnValue;

    public OperationsFactory(TransportFactory transportFactory, String cacheName, AtomicInteger topologyId, boolean forceReturnValue) {
        this.transportFactory = transportFactory;
        this.cacheNameBytes = cacheName.equals("___defaultcache") ? DEFAULT_CACHE_NAME_BYTES : cacheName.getBytes(HOTROD_STRING_CHARSET);
        this.topologyId = topologyId;
        this.forceReturnValue = forceReturnValue;
    }

    public GetOperation newGetKeyOperation(byte[] key) {
        return new GetOperation(this.transportFactory, key, this.cacheNameBytes, this.topologyId, this.flags());
    }

    public RemoveOperation newRemoveOperation(byte[] key) {
        return new RemoveOperation(this.transportFactory, key, this.cacheNameBytes, this.topologyId, this.flags());
    }

    public RemoveIfUnmodifiedOperation newRemoveIfUnmodifiedOperation(byte[] key, long version) {
        return new RemoveIfUnmodifiedOperation(this.transportFactory, key, this.cacheNameBytes, this.topologyId, this.flags(), version);
    }

    public ReplaceIfUnmodifiedOperation newReplaceIfUnmodifiedOperation(byte[] key, byte[] value, int lifespanSeconds, int maxIdleTimeSeconds, long version) {
        return new ReplaceIfUnmodifiedOperation(this.transportFactory, key, this.cacheNameBytes, this.topologyId, this.flags(), value, lifespanSeconds, maxIdleTimeSeconds, version);
    }

    public GetWithVersionOperation newGetWithVersionOperation(byte[] key) {
        return new GetWithVersionOperation(this.transportFactory, key, this.cacheNameBytes, this.topologyId, this.flags());
    }

    public StatsOperation newStatsOperation() {
        return new StatsOperation(this.transportFactory, this.cacheNameBytes, this.topologyId, this.flags());
    }

    public PutOperation newPutKeyValueOperation(byte[] key, byte[] value, int lifespanSecs, int maxIdleSecs) {
        return new PutOperation(this.transportFactory, key, this.cacheNameBytes, this.topologyId, this.flags(), value, lifespanSecs, maxIdleSecs);
    }

    public PutIfAbsentOperation newPutIfAbsentOperation(byte[] key, byte[] value, int lifespanSecs, int maxIdleSecs) {
        return new PutIfAbsentOperation(this.transportFactory, key, this.cacheNameBytes, this.topologyId, this.flags(), value, lifespanSecs, maxIdleSecs);
    }

    public ReplaceOperation newReplaceOperation(byte[] key, byte[] values, int lifespanSecs, int maxIdleSecs) {
        return new ReplaceOperation(this.transportFactory, key, this.cacheNameBytes, this.topologyId, this.flags(), values, lifespanSecs, maxIdleSecs);
    }

    public ContainsKeyOperation newContainsKeyOperation(byte[] key) {
        return new ContainsKeyOperation(this.transportFactory, key, this.cacheNameBytes, this.topologyId, this.flags());
    }

    public ClearOperation newClearOperation() {
        return new ClearOperation(this.transportFactory, this.cacheNameBytes, this.topologyId, this.flags());
    }

    public BulkGetOperation newBulkGetOperation(int size) {
        return new BulkGetOperation(this.transportFactory, this.cacheNameBytes, this.topologyId, this.flags(), size);
    }

    public PingOperation newPingOperation(Transport transport) {
        return new PingOperation(this.topologyId, transport, this.cacheNameBytes);
    }

    private Flag[] flags() {
        Flag[] flags = this.flagsMap.get();
        this.flagsMap.remove();
        if (flags == null && this.forceReturnValue) {
            return FORCE_RETURN_VALUE;
        }
        return flags;
    }

    public void setFlags(Flag[] flags) {
        this.flagsMap.set(flags);
    }
}

