/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketAddress;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.impl.ConfigurationProperties;
import org.infinispan.client.hotrod.impl.RemoteCacheImpl;
import org.infinispan.client.hotrod.impl.operations.OperationsFactory;
import org.infinispan.client.hotrod.impl.operations.PingOperation;
import org.infinispan.client.hotrod.impl.transport.Transport;
import org.infinispan.client.hotrod.impl.transport.TransportFactory;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.executors.ExecutorFactory;
import org.infinispan.manager.CacheContainer;
import org.infinispan.marshall.Marshaller;
import org.infinispan.util.FileLookupFactory;
import org.infinispan.util.Util;
import org.infinispan.util.logging.LogFactory;

public class RemoteCacheManager
implements CacheContainer {
    private static final Log log = (Log)LogFactory.getLog(RemoteCacheManager.class, Log.class);
    public static final String HOTROD_CLIENT_PROPERTIES = "hotrod-client.properties";
    ConfigurationProperties config;
    private TransportFactory transportFactory;
    private Marshaller marshaller;
    private volatile boolean started = false;
    private boolean forceReturnValueDefault = false;
    private ExecutorService asyncExecutorService;
    private final Map<String, RemoteCacheImpl> cacheName2RemoteCache = new HashMap<String, RemoteCacheImpl>();
    private AtomicInteger topologyId = new AtomicInteger();
    private ClassLoader classLoader;

    public RemoteCacheManager(Marshaller marshaller, Properties props, boolean start) {
        this(marshaller, props, start, Thread.currentThread().getContextClassLoader(), null);
    }

    public RemoteCacheManager(Marshaller marshaller, Properties props, boolean start, ClassLoader classLoader, ExecutorFactory asyncExecutorFactory) {
        this(props, start, classLoader, asyncExecutorFactory);
        this.setMarshaller(marshaller);
        if (log.isTraceEnabled()) {
            log.tracef("Using explicitly set marshaller type: %s", marshaller.getClass().getName());
        }
        if (start) {
            this.start();
        }
    }

    public RemoteCacheManager(Marshaller marshaller, Properties props) {
        this(marshaller, props, true);
    }

    public RemoteCacheManager(Marshaller marshaller, Properties props, ExecutorFactory asyncExecutorFactory) {
        this(marshaller, props, true, Thread.currentThread().getContextClassLoader(), asyncExecutorFactory);
    }

    public RemoteCacheManager(Marshaller marshaller, Properties props, ClassLoader classLoader) {
        this(marshaller, props, true, classLoader, null);
    }

    public RemoteCacheManager(Properties props, boolean start) {
        this(props, start, Thread.currentThread().getContextClassLoader(), null);
    }

    public RemoteCacheManager(Properties props, boolean start, ClassLoader classLoader, ExecutorFactory asyncExecutorFactory) {
        this.config = new ConfigurationProperties(props);
        this.classLoader = classLoader;
        if (asyncExecutorFactory != null) {
            this.asyncExecutorService = asyncExecutorFactory.getExecutor(props);
        }
        if (start) {
            this.start();
        }
    }

    public RemoteCacheManager(Properties props) {
        this(props, Thread.currentThread().getContextClassLoader());
    }

    public RemoteCacheManager(Properties props, ClassLoader classLoader) {
        this(props, true, classLoader, null);
    }

    public Properties getProperties() {
        return (Properties)this.config.getProperties().clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteCacheManager(boolean start) {
        this.classLoader = Thread.currentThread().getContextClassLoader();
        InputStream stream = FileLookupFactory.newInstance().lookupFile(HOTROD_CLIENT_PROPERTIES, this.classLoader);
        if (stream == null) {
            log.couldNotFindPropertiesFile(HOTROD_CLIENT_PROPERTIES);
            this.config = new ConfigurationProperties();
        } else {
            try {
                this.loadFromStream(stream);
            }
            finally {
                Util.close((Closeable)stream);
            }
        }
        if (start) {
            this.start();
        }
    }

    public RemoteCacheManager() {
        this(true);
    }

    public RemoteCacheManager(String host, int port, boolean start) {
        this(host, port, start, Thread.currentThread().getContextClassLoader());
    }

    public RemoteCacheManager(String host, int port, boolean start, ClassLoader classLoader) {
        this.config = new ConfigurationProperties(host + ":" + port);
        this.classLoader = classLoader;
        if (start) {
            this.start();
        }
    }

    public RemoteCacheManager(String host, int port) {
        this(host, port, Thread.currentThread().getContextClassLoader());
    }

    public RemoteCacheManager(String host, int port, ClassLoader classLoader) {
        this(host, port, true, classLoader);
    }

    public RemoteCacheManager(String servers, boolean start) {
        this(servers, start, Thread.currentThread().getContextClassLoader());
    }

    public RemoteCacheManager(String servers, boolean start, ClassLoader classLoader) {
        this.config = new ConfigurationProperties(servers);
        this.classLoader = classLoader;
        if (start) {
            this.start();
        }
    }

    public RemoteCacheManager(String servers) {
        this(servers, Thread.currentThread().getContextClassLoader());
    }

    public RemoteCacheManager(String servers, ClassLoader classLoader) {
        this(servers, true, classLoader);
    }

    public RemoteCacheManager(URL config, boolean start) {
        this(config, start, Thread.currentThread().getContextClassLoader());
    }

    public RemoteCacheManager(URL config, boolean start, ClassLoader classLoader) {
        this.classLoader = classLoader;
        InputStream stream = null;
        try {
            stream = config.openStream();
            this.loadFromStream(stream);
        }
        catch (IOException e) {
            throw new HotRodClientException("Could not read URL:" + config, e);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException e) {}
        }
        if (start) {
            this.start();
        }
    }

    public RemoteCacheManager(URL config) {
        this(config, Thread.currentThread().getContextClassLoader());
    }

    public RemoteCacheManager(URL config, ClassLoader classLoader) {
        this(config, true, classLoader);
    }

    public <K, V> RemoteCache<K, V> getCache(String cacheName) {
        return this.getCache(cacheName, this.forceReturnValueDefault);
    }

    public <K, V> RemoteCache<K, V> getCache(String cacheName, boolean forceReturnValue) {
        return this.createRemoteCache(cacheName, forceReturnValue);
    }

    public <K, V> RemoteCache<K, V> getCache() {
        return this.getCache(this.forceReturnValueDefault);
    }

    public <K, V> RemoteCache<K, V> getCache(boolean forceReturnValue) {
        return this.createRemoteCache("", forceReturnValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        String factory = this.config.getTransportFactory();
        this.transportFactory = (TransportFactory)Util.getInstance((String)factory, (ClassLoader)this.classLoader);
        Collection<SocketAddress> servers = this.config.getServerList();
        this.transportFactory.start(this.config, servers, this.topologyId, this.classLoader);
        if (this.marshaller == null) {
            String marshallerName = this.config.getMarshaller();
            this.setMarshaller((Marshaller)Util.getInstance((String)marshallerName, (ClassLoader)this.classLoader));
        }
        if (this.asyncExecutorService == null) {
            String asyncExecutorClass = this.config.getAsyncExecutorFactory();
            ExecutorFactory executorFactory = (ExecutorFactory)Util.getInstance((String)asyncExecutorClass, (ClassLoader)this.classLoader);
            this.asyncExecutorService = executorFactory.getExecutor(this.config.getProperties());
        }
        this.forceReturnValueDefault = this.config.getForceReturnValues();
        Map<String, RemoteCacheImpl> map = this.cacheName2RemoteCache;
        synchronized (map) {
            for (RemoteCacheImpl remoteCache : this.cacheName2RemoteCache.values()) {
                this.startRemoteCache(remoteCache);
            }
        }
        this.started = true;
    }

    public void stop() {
        if (this.isStarted()) {
            this.transportFactory.destroy();
            this.asyncExecutorService.shutdownNow();
        }
        this.started = false;
    }

    public boolean isStarted() {
        return this.started;
    }

    private void loadFromStream(InputStream stream) {
        Properties properties = new Properties();
        try {
            properties.load(stream);
        }
        catch (IOException e) {
            throw new HotRodClientException("Issues configuring from client hotrod-client.properties", e);
        }
        this.config = new ConfigurationProperties(properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <K, V> RemoteCache<K, V> createRemoteCache(String cacheName, boolean forceReturnValue) {
        Map<String, RemoteCacheImpl> map = this.cacheName2RemoteCache;
        synchronized (map) {
            if (!this.cacheName2RemoteCache.containsKey(cacheName)) {
                RemoteCacheImpl result = new RemoteCacheImpl(this, cacheName);
                this.startRemoteCache(result);
                if (!cacheName.equals("___defaultcache") && this.ping(result) == PingOperation.PingResult.CACHE_DOES_NOT_EXIST) {
                    return null;
                }
                this.cacheName2RemoteCache.put(cacheName, result);
                return result;
            }
            return this.cacheName2RemoteCache.get(cacheName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <K, V> PingOperation.PingResult ping(RemoteCacheImpl<K, V> cache) {
        if (this.transportFactory == null) {
            return PingOperation.PingResult.FAIL;
        }
        Transport transport = this.transportFactory.getTransport();
        try {
            PingOperation.PingResult pingResult = cache.ping(transport);
            return pingResult;
        }
        finally {
            this.transportFactory.releaseTransport(transport);
        }
    }

    private <K, V> void startRemoteCache(RemoteCacheImpl<K, V> result) {
        OperationsFactory operationsFactory = new OperationsFactory(this.transportFactory, result.getName(), this.topologyId, this.forceReturnValueDefault);
        result.init(this.marshaller, this.asyncExecutorService, operationsFactory, this.config.getKeySizeEstimate(), this.config.getValueSizeEstimate());
    }

    private void setMarshaller(Marshaller marshaller) {
        this.marshaller = marshaller;
    }
}

