/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.consistenthash;

import java.net.SocketAddress;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.infinispan.client.hotrod.impl.consistenthash.ConsistentHash;
import org.infinispan.util.hash.Hash;
import org.infinispan.util.hash.MurmurHash2;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class ConsistentHashV1
implements ConsistentHash {
    private static final Log log = LogFactory.getLog(ConsistentHashV1.class);
    private final SortedMap<Integer, SocketAddress> positions = new TreeMap<Integer, SocketAddress>();
    private int hashSpace;
    protected Hash hash = new MurmurHash2();
    private int numKeyOwners;
    private Random rnd = new Random();

    @Override
    public void init(Map<SocketAddress, Set<Integer>> servers2Hash, int numKeyOwners, int hashSpace) {
        for (Map.Entry<SocketAddress, Set<Integer>> entry : servers2Hash.entrySet()) {
            SocketAddress addr = entry.getKey();
            for (Integer hash : entry.getValue()) {
                SocketAddress prev = this.positions.put(hash, addr);
                if (prev == null) continue;
                log.debugf("Adding hash (%d) again, this time for %s. Previously it was associated with: %s", (Object)hash, (Object)addr, (Object)prev);
            }
        }
        log.tracef("Positions (%d entries) are: %s", (Object)this.positions.size(), this.positions);
        this.hashSpace = hashSpace;
        this.numKeyOwners = numKeyOwners;
    }

    @Override
    public SocketAddress getServer(byte[] key) {
        int keyHashCode = this.hash.hash(key);
        if (keyHashCode == Integer.MIN_VALUE) {
            ++keyHashCode;
        }
        int hash = Math.abs(keyHashCode);
        SortedMap<Integer, SocketAddress> candidates = this.positions.tailMap(hash % this.hashSpace);
        if (log.isTraceEnabled()) {
            log.tracef("Found possible candidates: %s", candidates);
        }
        int index = this.getIndex();
        if (candidates.size() <= index) {
            int newIndex = index - candidates.size();
            SocketAddress socketAddress = this.getItemAtPosition(newIndex, this.positions);
            if (log.isTraceEnabled()) {
                log.tracef("Over the wheel, returning member: %s", (Object)socketAddress);
            }
            return socketAddress;
        }
        SocketAddress socketAddress = this.getItemAtPosition(index, candidates);
        if (log.isTraceEnabled()) {
            log.tracef("Found candidate: %s", (Object)socketAddress);
        }
        return socketAddress;
    }

    private int getIndex() {
        return this.rnd.nextInt(Math.min(this.numKeyOwners, this.positions.size()));
    }

    private SocketAddress getItemAtPosition(int position, SortedMap<Integer, SocketAddress> map) {
        Iterator<Map.Entry<Integer, SocketAddress>> iterator = map.entrySet().iterator();
        for (int i = 0; i < position; ++i) {
            iterator.next();
        }
        return iterator.next().getValue();
    }

    public void setHash(Hash hash) {
        this.hash = hash;
    }
}

