/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import java.util.concurrent.atomic.AtomicInteger;
import net.jcip.annotations.Immutable;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.exceptions.RemoteNodeSuspecException;
import org.infinispan.client.hotrod.exceptions.TransportException;
import org.infinispan.client.hotrod.impl.operations.HotRodOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.transport.Transport;
import org.infinispan.client.hotrod.impl.transport.TransportFactory;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;

@Immutable
public abstract class RetryOnFailureOperation
extends HotRodOperation {
    private static final Log log = LogFactory.getLog(RetryOnFailureOperation.class, Log.class);
    protected final TransportFactory transportFactory;

    protected RetryOnFailureOperation(Codec codec, TransportFactory transportFactory, byte[] cacheName, AtomicInteger topologyId, Flag[] flags) {
        super(codec, flags, cacheName, topologyId);
        this.transportFactory = transportFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute() {
        int retryCount = 0;
        while (this.shouldRetry(retryCount)) {
            Transport transport = null;
            try {
                transport = this.getTransport(retryCount);
                Object object = this.executeOperation(transport);
                return object;
            }
            catch (TransportException te) {
                this.logErrorAndThrowExceptionIfNeeded(retryCount, te);
            }
            catch (RemoteNodeSuspecException e) {
                this.logErrorAndThrowExceptionIfNeeded(retryCount, e);
            }
            finally {
                this.releaseTransport(transport);
            }
            ++retryCount;
        }
        throw new IllegalStateException("We should not reach here!");
    }

    protected boolean shouldRetry(int retryCount) {
        return retryCount < this.transportFactory.getTransportCount();
    }

    protected void logErrorAndThrowExceptionIfNeeded(int i, HotRodClientException e) {
        String message = "Exception encountered. Retry %d out of %d";
        if (i >= this.transportFactory.getTransportCount() - 1 || this.transportFactory.getTransportCount() < 0) {
            log.exceptionAndNoRetriesLeft(i, this.transportFactory.getTransportCount(), e);
            throw e;
        }
        log.tracef(e, message, i, this.transportFactory.getTransportCount());
    }

    protected void releaseTransport(Transport transport) {
        if (transport != null) {
            this.transportFactory.releaseTransport(transport);
        }
    }

    protected abstract Transport getTransport(int var1);

    protected abstract Object executeOperation(Transport var1);
}

