/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.lang.reflect.Method;
import java.net.SocketTimeoutException;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.CacheException;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.TestHelper;
import org.infinispan.client.hotrod.exceptions.TransportException;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test(testName="client.hotrod.ClientSocketReadTimeoutTest", groups={"functional"})
public class ClientSocketReadTimeoutTest
extends SingleCacheManagerTest {
    HotRodServer hotrodServer;
    RemoteCacheManager remoteCacheManager;
    RemoteCache defaultRemote;
    CountDownLatch latch;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        this.latch = new CountDownLatch(1);
        this.cacheManager = new HangingCacheManager(TestCacheManagerFactory.createLocalCacheManager((boolean)false), this.latch);
        this.hotrodServer = TestHelper.startHotRodServer(this.cacheManager);
        this.log.info((Object)("Started server on port: " + this.hotrodServer.getPort()));
        this.remoteCacheManager = this.getRemoteCacheManager();
        this.defaultRemote = this.remoteCacheManager.getCache();
        return this.cacheManager;
    }

    protected RemoteCacheManager getRemoteCacheManager() {
        Properties config = new Properties();
        config.put("infinispan.client.hotrod.server_list", "127.0.0.1:" + this.hotrodServer.getPort());
        config.put("infinispan.client.hotrod.socket_timeout", "5000");
        return new RemoteCacheManager(config);
    }

    @AfterClass
    public void destroyRemoteCacheFactory() {
        this.remoteCacheManager.stop();
        this.hotrodServer.stop();
    }

    @Test(expectedExceptions={SocketTimeoutException.class})
    public void testPutTimeout(Method m) throws Throwable {
        try {
            assert (null == this.defaultRemote.put((Object)TestingUtil.k((Method)m), (Object)TestingUtil.v((Method)m)));
        }
        catch (TransportException e) {
            throw e.getCause();
        }
    }

    private static class HangingCacheManager
    implements EmbeddedCacheManager {
        final EmbeddedCacheManager delegate;
        final CountDownLatch latch;

        public HangingCacheManager(EmbeddedCacheManager delegate, CountDownLatch latch) {
            this.delegate = delegate;
            this.latch = latch;
        }

        public org.infinispan.config.Configuration defineConfiguration(String cacheName, org.infinispan.config.Configuration configurationOverride) {
            return this.delegate.defineConfiguration(cacheName, configurationOverride);
        }

        public Configuration defineConfiguration(String cacheName, Configuration configurationOverride) {
            return this.delegate.defineConfiguration(cacheName, configurationOverride);
        }

        public org.infinispan.config.Configuration defineConfiguration(String cacheName, String templateCacheName, org.infinispan.config.Configuration configurationOverride) {
            return this.delegate.defineConfiguration(cacheName, templateCacheName, configurationOverride);
        }

        public String getClusterName() {
            return this.delegate.getClusterName();
        }

        public List<Address> getMembers() {
            return this.delegate.getMembers();
        }

        public Address getAddress() {
            return this.delegate.getAddress();
        }

        public Address getCoordinator() {
            return this.delegate.getCoordinator();
        }

        public boolean isCoordinator() {
            return this.delegate.isCoordinator();
        }

        public ComponentStatus getStatus() {
            return this.delegate.getStatus();
        }

        public GlobalConfiguration getGlobalConfiguration() {
            return this.delegate.getGlobalConfiguration();
        }

        public org.infinispan.config.Configuration getDefaultConfiguration() {
            return this.delegate.getDefaultConfiguration();
        }

        public Set<String> getCacheNames() {
            return this.delegate.getCacheNames();
        }

        public boolean isRunning(String cacheName) {
            return this.delegate.isRunning(cacheName);
        }

        public boolean isDefaultRunning() {
            return this.delegate.isDefaultRunning();
        }

        public boolean cacheExists(String cacheName) {
            return this.delegate.cacheExists(cacheName);
        }

        public <K, V> Cache<K, V> getCache(String cacheName, boolean createIfAbsent) {
            return this.delegate.getCache(cacheName, createIfAbsent);
        }

        public EmbeddedCacheManager startCaches(String ... cacheNames) {
            return this.delegate.startCaches(cacheNames);
        }

        public void removeCache(String cacheName) {
            this.delegate.removeCache(cacheName);
        }

        public Transport getTransport() {
            return this.delegate.getTransport();
        }

        public <K, V> Cache<K, V> getCache() {
            String threadName = Thread.currentThread().getName();
            if (threadName.startsWith("HotRodServerWorker")) {
                try {
                    this.latch.await(180L, TimeUnit.SECONDS);
                    return this.delegate.getCache();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new CacheException((Throwable)e);
                }
            }
            return this.delegate.getCache();
        }

        public <K, V> Cache<K, V> getCache(String cacheName) {
            return this.delegate.getCache(cacheName);
        }

        public void start() {
            this.delegate.start();
        }

        public void stop() {
            this.delegate.stop();
        }

        public void addListener(Object listener) {
            this.delegate.addListener(listener);
        }

        public void removeListener(Object listener) {
            this.delegate.removeListener(listener);
        }

        public Set<Object> getListeners() {
            return this.delegate.getListeners();
        }
    }
}

