/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.retry;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Random;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.infinispan.Cache;
import org.infinispan.affinity.KeyAffinityService;
import org.infinispan.affinity.KeyAffinityServiceFactory;
import org.infinispan.affinity.KeyGenerator;
import org.infinispan.client.hotrod.VersionedValue;
import org.infinispan.client.hotrod.impl.transport.Transport;
import org.infinispan.client.hotrod.impl.transport.tcp.TcpTransport;
import org.infinispan.client.hotrod.impl.transport.tcp.TcpTransportFactory;
import org.infinispan.client.hotrod.retry.AbstractRetryTest;
import org.infinispan.config.Configuration;
import org.infinispan.marshall.jboss.JBossMarshaller;
import org.infinispan.remoting.transport.Address;
import org.infinispan.test.TestingUtil;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(testName="hotrod.retry.DistributionRetryTest", groups={"functional"})
public class DistributionRetryTest
extends AbstractRetryTest {
    @Override
    protected Configuration getCacheConfig() {
        Configuration config = DistributionRetryTest.getDefaultClusteredConfig((Configuration.CacheMode)Configuration.CacheMode.DIST_SYNC);
        config.setNumOwners(1);
        return config;
    }

    public void testGet() throws Exception {
        this.log.info((Object)"Starting actual test");
        Object key = this.generateKeyAndShutdownServer();
        this.resetStats();
        Assert.assertEquals((Object)this.remoteCache.get(key), (Object)"v");
    }

    public void testPut() throws Exception {
        Object key = this.generateKeyAndShutdownServer();
        this.log.info((Object)"Here it starts");
        Assert.assertEquals((Object)this.remoteCache.put(key, (Object)"v0"), (Object)"v");
    }

    public void testRemove() throws Exception {
        Object key = this.generateKeyAndShutdownServer();
        Assert.assertEquals((Object)"v", (Object)this.remoteCache.remove(key));
    }

    public void testContains() throws Exception {
        Object key = this.generateKeyAndShutdownServer();
        this.resetStats();
        Assert.assertEquals((boolean)true, (boolean)this.remoteCache.containsKey(key));
    }

    public void testGetWithVersion() throws Exception {
        Object key = this.generateKeyAndShutdownServer();
        this.resetStats();
        VersionedValue value = this.remoteCache.getVersioned(key);
        Assert.assertEquals((Object)"v", (Object)value.getValue());
    }

    public void testPutIfAbsent() throws Exception {
        Object key = this.generateKeyAndShutdownServer();
        Assert.assertEquals(null, (Object)this.remoteCache.putIfAbsent((Object)"noSuchKey", (Object)"someValue"));
        Assert.assertEquals((Object)"someValue", (Object)this.remoteCache.get((Object)"noSuchKey"));
    }

    public void testReplace() throws Exception {
        Object key = this.generateKeyAndShutdownServer();
        Assert.assertEquals((Object)"v", (Object)this.remoteCache.replace(key, (Object)"v2"));
    }

    public void testReplaceIfUnmodified() throws Exception {
        Object key = this.generateKeyAndShutdownServer();
        Assert.assertEquals((boolean)false, (boolean)this.remoteCache.replaceWithVersion(key, (Object)"v2", 12L));
    }

    public void testRemoveIfUnmodified() throws Exception {
        Object key = this.generateKeyAndShutdownServer();
        this.resetStats();
        Assert.assertEquals((boolean)false, (boolean)this.remoteCache.removeWithVersion(key, 12L));
    }

    public void testClear() throws Exception {
        Object key = this.generateKeyAndShutdownServer();
        this.resetStats();
        this.remoteCache.clear();
        Assert.assertEquals((boolean)false, (boolean)this.remoteCache.containsKey(key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object generateKeyAndShutdownServer() throws IOException, ClassNotFoundException, InterruptedException {
        this.resetStats();
        Cache cache = this.manager(1).getCache();
        KeyAffinityService kaf = KeyAffinityServiceFactory.newKeyAffinityService((Cache)cache, (Executor)Executors.newSingleThreadExecutor(), (KeyGenerator)new ByteKeyGenerator(), (int)2, (boolean)true);
        Address address = cache.getAdvancedCache().getRpcManager().getTransport().getAddress();
        byte[] keyBytes = (byte[])kaf.getKeyForAddress(address);
        String key = ByteKeyGenerator.getStringObject(keyBytes);
        kaf.stop();
        this.remoteCache.put((Object)key, (Object)"v");
        this.assertOnlyServerHit(this.getAddress(this.hotRodServer2));
        TcpTransportFactory tcpTp = (TcpTransportFactory)TestingUtil.extractField((Object)this.remoteCacheManager, (String)"transportFactory");
        JBossMarshaller sm = new JBossMarshaller();
        TcpTransport transport = (TcpTransport)tcpTp.getTransport(sm.objectToByteBuffer((Object)key, 64));
        try {
            Assert.assertEquals((Object)transport.getServerAddress(), (Object)new InetSocketAddress("localhost", this.hotRodServer2.getPort()));
        }
        finally {
            tcpTp.releaseTransport((Transport)transport);
        }
        this.log.info((Object)"About to stop Hot Rod server 2");
        this.hotRodServer2.stop();
        return key;
    }

    public static class ByteKeyGenerator
    implements KeyGenerator {
        Random r = new Random();

        public Object getKey() {
            String result = String.valueOf(this.r.nextLong());
            JBossMarshaller sm = new JBossMarshaller();
            try {
                return sm.objectToByteBuffer((Object)result, 64);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }

        public static String getStringObject(byte[] bytes) {
            try {
                JBossMarshaller sm = new JBossMarshaller();
                return (String)sm.objectFromByteBuffer(bytes);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

