/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Properties;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.TestHelper;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.config.Configuration;
import org.infinispan.config.CustomInterceptorConfig;
import org.infinispan.context.InvocationContext;
import org.infinispan.interceptors.EntryWrappingInterceptor;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.marshall.jboss.JBossMarshaller;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.ByteArrayKey;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.SocketTimeoutErrorTest")
public class SocketTimeoutErrorTest
extends SingleCacheManagerTest {
    protected HotRodServer hotrodServer;
    protected RemoteCacheManager remoteCacheManager;
    protected RemoteCache remoteCache;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        Configuration cfg = new Configuration();
        CustomInterceptorConfig cic = new CustomInterceptorConfig((CommandInterceptor)new TimeoutInducingInterceptor(), false, false, -1, EntryWrappingInterceptor.class.getName(), "");
        cfg.setCustomInterceptors(Collections.singletonList(cic));
        this.cacheManager = TestCacheManagerFactory.createCacheManager((Configuration)cfg);
        this.hotrodServer = TestHelper.startHotRodServer(this.cacheManager);
        this.remoteCacheManager = new RemoteCacheManager(this.getClientProperties());
        this.remoteCache = this.remoteCacheManager.getCache();
        return this.cacheManager;
    }

    protected Properties getClientProperties() {
        Properties props = new Properties();
        props.put("infinispan.client.hotrod.server_list", "127.0.0.1:" + this.hotrodServer.getPort());
        props.setProperty("infinispan.client.hotrod.socket_timeout", "3000");
        props.setProperty("maxActive", "1");
        props.setProperty("maxTotal", "1");
        props.setProperty("maxIdle", "1");
        props.setProperty("maxIdle", "1");
        return props;
    }

    public void testErrorWhileDoingPut(Method m) throws Exception {
        this.remoteCache = this.remoteCacheManager.getCache();
        this.remoteCache.put((Object)TestingUtil.k((Method)m), (Object)TestingUtil.v((Method)m));
        assert (this.remoteCache.get((Object)TestingUtil.k((Method)m)).equals(TestingUtil.v((Method)m)));
        try {
            this.remoteCache.put((Object)"FailFailFail", (Object)"whatever...");
        }
        catch (HotRodClientException e) {
            // empty catch block
        }
        for (int i = 0; i < 200; ++i) {
            try {
                this.remoteCache.put((Object)TestingUtil.k((Method)m, (int)i), (Object)TestingUtil.v((Method)m, (int)i));
                if ($assertionsDisabled || this.remoteCache.get((Object)TestingUtil.k((Method)m, (int)i)).equals(TestingUtil.v((Method)m, (int)i))) continue;
                throw new AssertionError();
            }
            catch (Exception e) {
                this.log.error((Object)"Error sending request after server failure", (Throwable)e);
                throw e;
            }
        }
    }

    public static class TimeoutInducingInterceptor
    extends CommandInterceptor {
        public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
            if (this.unmarshall(command.getKey()).equals("FailFailFail")) {
                Thread.sleep(6000L);
            }
            return super.visitPutKeyValueCommand(ctx, command);
        }

        private String unmarshall(Object key) throws Exception {
            JBossMarshaller marshaller = new JBossMarshaller();
            return (String)marshaller.objectFromByteBuffer(((ByteArrayKey)key).getData());
        }
    }
}

