/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.infinispan.Cache;
import org.infinispan.affinity.KeyAffinityService;
import org.infinispan.affinity.KeyAffinityServiceFactory;
import org.infinispan.affinity.KeyGenerator;
import org.infinispan.client.hotrod.HitsAwareCacheManagersTest;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.TestHelper;
import org.infinispan.client.hotrod.impl.RemoteCacheImpl;
import org.infinispan.client.hotrod.retry.DistributionRetryTest;
import org.infinispan.config.Configuration;
import org.infinispan.interceptors.InterceptorChain;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.remoting.transport.Address;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.util.Util;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterTest;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.ConsistentHashV1IntegrationTest")
public class ConsistentHashV1IntegrationTest
extends MultipleCacheManagersTest {
    private HotRodServer hotRodServer1;
    private HotRodServer hotRodServer2;
    private HotRodServer hotRodServer3;
    private HotRodServer hotRodServer4;
    private RemoteCacheManager remoteCacheManager;
    private RemoteCacheImpl remoteCache;
    private KeyAffinityService kas;
    private ExecutorService ex;

    protected void createCacheManagers() throws Throwable {
        Configuration conf = ConsistentHashV1IntegrationTest.getDefaultClusteredConfig((Configuration.CacheMode)Configuration.CacheMode.DIST_SYNC, (boolean)false);
        conf.fluent().jmxStatistics();
        assert (conf.isExposeJmxStatistics());
        conf.fluent().hash().numOwners(Integer.valueOf(2));
        conf.fluent().hash().rehashEnabled(Boolean.valueOf(false));
        this.addClusterEnabledCacheManager(conf);
        this.addClusterEnabledCacheManager(conf);
        this.addClusterEnabledCacheManager(conf);
        this.addClusterEnabledCacheManager(conf);
        this.hotRodServer1 = TestHelper.startHotRodServer(this.manager(0));
        this.hotRodServer2 = TestHelper.startHotRodServer(this.manager(1));
        this.hotRodServer3 = TestHelper.startHotRodServer(this.manager(2));
        this.hotRodServer4 = TestHelper.startHotRodServer(this.manager(3));
        this.waitForClusterToForm();
        Properties clientConfig = new Properties();
        clientConfig.put("infinispan.client.hotrod.server_list", "localhost:" + this.hotRodServer2.getPort());
        this.remoteCacheManager = new RemoteCacheManager(clientConfig);
        this.remoteCache = (RemoteCacheImpl)this.remoteCacheManager.getCache();
        assert (this.cacheManagers.size() == 4);
        this.ex = Executors.newSingleThreadExecutor();
        this.kas = KeyAffinityServiceFactory.newKeyAffinityService((Cache)this.cache(0), (Executor)this.ex, (KeyGenerator)new DistributionRetryTest.ByteKeyGenerator(), (int)2, (boolean)true);
        for (int i = 0; i < 4; ++i) {
            this.advancedCache(i).addInterceptor((CommandInterceptor)new HitsAwareCacheManagersTest.HitCountInterceptor(), 1);
        }
    }

    @AfterMethod
    protected void clearContent() throws Throwable {
    }

    @AfterTest
    public void cleanUp() {
        this.ex.shutdownNow();
        this.kas.stop();
        this.stopServer(this.hotRodServer1);
        this.stopServer(this.hotRodServer2);
        this.stopServer(this.hotRodServer3);
        this.stopServer(this.hotRodServer4);
        this.remoteCache.stop();
        this.remoteCacheManager.stop();
    }

    private void stopServer(HotRodServer hrs) {
        try {
            hrs.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testCorrectBalancingOfKeys() {
        this.runTest(0);
        this.runTest(1);
        this.runTest(2);
        this.runTest(3);
    }

    private void runTest(int cacheIndex) {
        List backups = this.advancedCache(cacheIndex).getDistributionManager().getConsistentHash().locate((Object)this.address(cacheIndex), 2);
        assert (backups.contains(this.address(cacheIndex)));
        HashMap<Object, Integer> hitNodes = new HashMap<Object, Integer>();
        hitNodes.put(backups.get(0), 0);
        hitNodes.put(backups.get(1), 0);
        for (int i = 0; i < 1000; ++i) {
            String key = this.getKey(cacheIndex);
            this.remoteCache.put((Object)key, (Object)"v");
            Address hitServer = this.getHitServer();
            assert (backups.contains(hitServer)) : String.format("i=%s, backups: %s, hit server: %s, key=%s", i, backups, hitServer, Util.printArray((byte[])key.getBytes(), (boolean)false));
            hitNodes.put(hitServer, (Integer)hitNodes.get(hitServer) + 1);
        }
        System.out.println("hitNodes = " + hitNodes);
        assert (backups.containsAll(hitNodes.keySet())) : String.format("Backups %s. hit nodes %s", backups, hitNodes);
    }

    private String getKey(int cacheIndex) {
        byte[] keyBytes = (byte[])this.kas.getKeyForAddress(this.address(cacheIndex));
        return DistributionRetryTest.ByteKeyGenerator.getStringObject(keyBytes);
    }

    private Address getHitServer() {
        ArrayList<Address> result = new ArrayList<Address>();
        for (int i = 0; i < 4; ++i) {
            InterceptorChain ic = (InterceptorChain)this.advancedCache(i).getComponentRegistry().getComponent(InterceptorChain.class);
            HitsAwareCacheManagersTest.HitCountInterceptor interceptor = (HitsAwareCacheManagersTest.HitCountInterceptor)((Object)ic.getInterceptorsWithClassName(HitsAwareCacheManagersTest.HitCountInterceptor.class.getName()).get(0));
            if (interceptor.getHits() == 1) {
                result.add(this.address(i));
            }
            interceptor.reset();
        }
        if (result.size() > 1) {
            throw new IllegalStateException("More than one hit! : " + result);
        }
        return (Address)result.get(0);
    }
}

