/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.TestHelper;
import org.infinispan.client.hotrod.VersionedValue;
import org.infinispan.config.Configuration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.marshall.jboss.JBossMarshaller;
import org.infinispan.server.core.CacheValue;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.ByteArrayKey;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test(testName="client.hotrod.HotRodIntegrationTest", groups={"functional"})
public class HotRodIntegrationTest
extends SingleCacheManagerTest {
    private static final Log log = LogFactory.getLog(HotRodIntegrationTest.class);
    private static final String CACHE_NAME = "replSync";
    private Cache cache;
    private Cache defaultCache;
    RemoteCache defaultRemote;
    RemoteCache remoteCache;
    private RemoteCacheManager remoteCacheManager;
    protected HotRodServer hotrodServer;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        Configuration standaloneConfig = this.getDefaultStandaloneConfig(false);
        this.cacheManager = TestCacheManagerFactory.createLocalCacheManager((boolean)false);
        this.cacheManager.defineConfiguration(CACHE_NAME, standaloneConfig);
        this.defaultCache = this.cacheManager.getCache();
        this.cache = this.cacheManager.getCache(CACHE_NAME);
        this.hotrodServer = TestHelper.startHotRodServer(this.cacheManager);
        log.info((Object)("Started server on port: " + this.hotrodServer.getPort()));
        this.remoteCacheManager = this.getRemoteCacheManager();
        this.defaultRemote = this.remoteCacheManager.getCache();
        this.remoteCache = this.remoteCacheManager.getCache(CACHE_NAME);
        return this.cacheManager;
    }

    protected RemoteCacheManager getRemoteCacheManager() {
        Properties config = new Properties();
        config.put("infinispan.client.hotrod.server_list", "127.0.0.1:" + this.hotrodServer.getPort());
        return new RemoteCacheManager(config);
    }

    @AfterClass
    public void testDestroyRemoteCacheFactory() {
        this.remoteCacheManager.stop();
        this.hotrodServer.stop();
    }

    public void testPut() throws Exception {
        assert (null == this.remoteCache.put((Object)"aKey", (Object)"aValue"));
        this.assertCacheContains(this.cache, "aKey", "aValue");
        assert (null == this.defaultRemote.put((Object)"otherKey", (Object)"otherValue"));
        this.assertCacheContains(this.defaultCache, "otherKey", "otherValue");
        assert (this.remoteCache.containsKey((Object)"aKey"));
        assert (this.defaultRemote.containsKey((Object)"otherKey"));
        assert (this.remoteCache.get((Object)"aKey").equals("aValue"));
        assert (this.defaultRemote.get((Object)"otherKey").equals("otherValue"));
    }

    public void testRemove() throws Exception {
        assert (null == this.remoteCache.put((Object)"aKey", (Object)"aValue"));
        this.assertCacheContains(this.cache, "aKey", "aValue");
        assert (this.remoteCache.get((Object)"aKey").equals("aValue"));
        assert (null == this.remoteCache.remove((Object)"aKey"));
        this.assertCacheContains(this.cache, "aKey", null);
        assert (!this.remoteCache.containsKey((Object)"aKey"));
    }

    public void testContains() {
        assert (!this.remoteCache.containsKey((Object)"aKey"));
        this.remoteCache.put((Object)"aKey", (Object)"aValue");
        assert (this.remoteCache.containsKey((Object)"aKey"));
    }

    public void testGetVersionedCacheEntry() {
        VersionedValue value = this.remoteCache.getVersioned((Object)"aKey");
        AssertJUnit.assertNull((String)("expected null but received: " + value), (Object)this.remoteCache.getVersioned((Object)"aKey"));
        this.remoteCache.put((Object)"aKey", (Object)"aValue");
        assert (this.remoteCache.get((Object)"aKey").equals("aValue"));
        VersionedValue valueBinary = this.remoteCache.getVersioned((Object)"aKey");
        assert (valueBinary != null);
        AssertJUnit.assertEquals((Object)valueBinary.getValue(), (Object)"aValue");
        log.info((Object)("Version is: " + valueBinary.getVersion()));
        this.remoteCache.put((Object)"aKey", (Object)"aValue");
        VersionedValue entry2 = this.remoteCache.getVersioned((Object)"aKey");
        AssertJUnit.assertEquals((Object)entry2.getValue(), (Object)"aValue");
        assert (entry2.getVersion() != valueBinary.getVersion());
        assert (!valueBinary.equals(entry2));
        this.remoteCache.put((Object)"aKey", (Object)"anotherValue");
        VersionedValue entry3 = this.remoteCache.getVersioned((Object)"aKey");
        AssertJUnit.assertEquals((Object)entry3.getValue(), (Object)"anotherValue");
        assert (entry3.getVersion() != entry2.getVersion());
        assert (!entry3.equals(entry2));
    }

    public void testReplace() {
        assert (null == this.remoteCache.replace((Object)"aKey", (Object)"anotherValue"));
        this.remoteCache.put((Object)"aKey", (Object)"aValue");
        assert (null == this.remoteCache.replace((Object)"aKey", (Object)"anotherValue"));
        assert (this.remoteCache.get((Object)"aKey").equals("anotherValue"));
    }

    public void testReplaceIfUnmodified() {
        assert (null == this.remoteCache.replace((Object)"aKey", (Object)"aValue"));
        this.remoteCache.put((Object)"aKey", (Object)"aValue");
        VersionedValue valueBinary = this.remoteCache.getVersioned((Object)"aKey");
        assert (this.remoteCache.replaceWithVersion((Object)"aKey", (Object)"aNewValue", valueBinary.getVersion()));
        VersionedValue entry2 = this.remoteCache.getVersioned((Object)"aKey");
        assert (entry2.getVersion() != valueBinary.getVersion());
        AssertJUnit.assertEquals((Object)entry2.getValue(), (Object)"aNewValue");
        assert (!this.remoteCache.replaceWithVersion((Object)"aKey", (Object)"aNewValue", valueBinary.getVersion()));
    }

    public void testReplaceIfUnmodifiedWithExpiry(Method m) throws InterruptedException {
        boolean key = true;
        this.remoteCache.put((Object)1, (Object)TestingUtil.v((Method)m));
        VersionedValue valueBinary = this.remoteCache.getVersioned((Object)1);
        int lifespanSecs = 3;
        long lifespan = TimeUnit.SECONDS.toMillis(lifespanSecs);
        long startTime = System.currentTimeMillis();
        String newValue = TestingUtil.v((Method)m, (int)2);
        assert (this.remoteCache.replaceWithVersion((Object)1, (Object)newValue, valueBinary.getVersion(), lifespanSecs));
        while (true) {
            Object value = this.remoteCache.get((Object)1);
            if (System.currentTimeMillis() >= startTime + lifespan) break;
            AssertJUnit.assertEquals((Object)TestingUtil.v((Method)m, (int)2), (Object)value);
            Thread.sleep(100L);
        }
        while (System.currentTimeMillis() < startTime + lifespan + 2000L && this.remoteCache.get((Object)1) != null) {
            Thread.sleep(50L);
        }
        AssertJUnit.assertNull((Object)this.remoteCache.get((Object)1));
    }

    public void testRemoveIfUnmodified() {
        assert (!this.remoteCache.removeWithVersion((Object)"aKey", 12321212L));
        this.remoteCache.put((Object)"aKey", (Object)"aValue");
        VersionedValue valueBinary = this.remoteCache.getVersioned((Object)"aKey");
        assert (this.remoteCache.removeWithVersion((Object)"aKey", valueBinary.getVersion()));
        assert (!this.cache.containsKey((Object)"aKey"));
        this.remoteCache.put((Object)"aKey", (Object)"aNewValue");
        VersionedValue entry2 = this.remoteCache.getVersioned((Object)"aKey");
        assert (entry2.getVersion() != valueBinary.getVersion());
        AssertJUnit.assertEquals((Object)entry2.getValue(), (Object)"aNewValue");
        assert (!this.remoteCache.removeWithVersion((Object)"aKey", valueBinary.getVersion()));
    }

    public void testPutIfAbsent() {
        this.remoteCache.put((Object)"aKey", (Object)"aValue");
        assert (null == this.remoteCache.putIfAbsent((Object)"aKey", (Object)"anotherValue"));
        AssertJUnit.assertEquals((Object)this.remoteCache.get((Object)"aKey"), (Object)"aValue");
        AssertJUnit.assertEquals((Object)this.remoteCache.get((Object)"aKey"), (Object)"aValue");
        assert (this.remoteCache.containsKey((Object)"aKey"));
    }

    public void testClear() {
        this.remoteCache.put((Object)"aKey", (Object)"aValue");
        this.remoteCache.put((Object)"aKey2", (Object)"aValue");
        this.remoteCache.clear();
        assert (!this.remoteCache.containsKey((Object)"aKey"));
        assert (!this.remoteCache.containsKey((Object)"aKey2"));
        assert (this.cache.isEmpty());
    }

    private void assertCacheContains(Cache cache, String key, String value) throws Exception {
        JBossMarshaller marshaller = new JBossMarshaller();
        byte[] keyBytes = marshaller.objectToByteBuffer((Object)key, 64);
        byte[] valueBytes = marshaller.objectToByteBuffer((Object)value, 64);
        ByteArrayKey cacheKey = new ByteArrayKey(keyBytes);
        CacheValue cacheValue = (CacheValue)cache.get((Object)cacheKey);
        if (value == null) {
            assert (cacheValue == null) : "Expected null value but received: " + cacheValue;
        } else assert (Arrays.equals(valueBytes, cacheValue.data()));
    }
}

