/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.lang.reflect.Method;
import java.net.SocketTimeoutException;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.CacheException;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.TestHelper;
import org.infinispan.client.hotrod.exceptions.TransportException;
import org.infinispan.manager.AbstractDelegatingEmbeddedCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test(testName="client.hotrod.ClientSocketReadTimeoutTest", groups={"functional"})
public class ClientSocketReadTimeoutTest
extends SingleCacheManagerTest {
    HotRodServer hotrodServer;
    RemoteCacheManager remoteCacheManager;
    RemoteCache defaultRemote;
    CountDownLatch latch;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        this.latch = new CountDownLatch(1);
        this.cacheManager = new HangingCacheManager(TestCacheManagerFactory.createLocalCacheManager((boolean)false), this.latch);
        this.hotrodServer = TestHelper.startHotRodServer(this.cacheManager);
        this.log.info((Object)("Started server on port: " + this.hotrodServer.getPort()));
        this.remoteCacheManager = this.getRemoteCacheManager();
        this.defaultRemote = this.remoteCacheManager.getCache();
        return this.cacheManager;
    }

    protected RemoteCacheManager getRemoteCacheManager() {
        Properties config = new Properties();
        config.put("infinispan.client.hotrod.server_list", "127.0.0.1:" + this.hotrodServer.getPort());
        config.put("infinispan.client.hotrod.socket_timeout", "5000");
        config.put("infinispan.client.hotrod.connect_timeout", "5000");
        return new RemoteCacheManager(config);
    }

    @AfterClass
    public void destroyRemoteCacheFactory() {
        this.remoteCacheManager.stop();
        this.hotrodServer.stop();
    }

    @Test(expectedExceptions={SocketTimeoutException.class})
    public void testPutTimeout(Method m) throws Throwable {
        try {
            assert (null == this.defaultRemote.put((Object)TestingUtil.k((Method)m), (Object)TestingUtil.v((Method)m)));
        }
        catch (TransportException e) {
            throw e.getCause();
        }
    }

    private static class HangingCacheManager
    extends AbstractDelegatingEmbeddedCacheManager {
        final CountDownLatch latch;

        public HangingCacheManager(EmbeddedCacheManager delegate, CountDownLatch latch) {
            super(delegate);
            this.latch = latch;
        }

        public <K, V> Cache<K, V> getCache() {
            String threadName = Thread.currentThread().getName();
            if (threadName.startsWith("HotRodServerWorker")) {
                try {
                    this.latch.await(180L, TimeUnit.SECONDS);
                    return super.getCache();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new CacheException((Throwable)e);
                }
            }
            return super.getCache();
        }
    }
}

