/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.util.Map;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.ServerStatistics;
import org.infinispan.client.hotrod.TestHelper;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.HotRodStatisticsTest")
public class HotRodStatisticsTest {
    private HotRodServer hotrodServer;
    private CacheContainer cacheContainer;
    private RemoteCacheManager rcm;
    private RemoteCache remoteCache;
    long startTime;

    @BeforeMethod
    protected void setup() throws Exception {
        this.cacheContainer = TestCacheManagerFactory.createCacheManagerEnforceJmxDomain((String)this.getClass().getSimpleName());
        this.hotrodServer = TestHelper.startHotRodServer((EmbeddedCacheManager)this.cacheContainer);
        this.startTime = System.currentTimeMillis();
        this.rcm = new RemoteCacheManager("localhost", this.hotrodServer.getPort());
        this.remoteCache = this.rcm.getCache();
    }

    @AfterMethod
    void tearDown() {
        TestingUtil.killCacheManagers((CacheContainer[])new CacheContainer[]{this.cacheContainer});
        this.rcm.stop();
        this.hotrodServer.stop();
    }

    public void testAllStatsArePresent() {
        ServerStatistics serverStatistics = this.remoteCache.stats();
        Map statsMap = serverStatistics.getStatsMap();
        AssertJUnit.assertEquals((String)((String)statsMap.get("stores")), (String)"0");
        AssertJUnit.assertEquals((String)((String)statsMap.get("currentNumberOfEntries")), (String)"0");
        AssertJUnit.assertEquals((String)((String)statsMap.get("hits")), (String)"0");
        AssertJUnit.assertEquals((String)((String)statsMap.get("misses")), (String)"0");
        AssertJUnit.assertEquals((String)((String)statsMap.get("removeHits")), (String)"0");
        AssertJUnit.assertEquals((String)((String)statsMap.get("removeMisses")), (String)"0");
        AssertJUnit.assertEquals((String)((String)statsMap.get("retrievals")), (String)"0");
        AssertJUnit.assertEquals((String)((String)statsMap.get("totalNumberOfEntries")), (String)"0");
        assert (0 == this.remoteCache.size());
        assert (this.remoteCache.isEmpty());
        Integer number = serverStatistics.getIntStatistic("timeSinceStart");
        AssertJUnit.assertTrue((number >= 0 ? 1 : 0) != 0);
    }

    public void testStoresAndEntries() {
        assert (0 == this.remoteCache.size());
        assert (this.remoteCache.isEmpty());
        this.remoteCache.put((Object)"a", (Object)"v");
        AssertJUnit.assertEquals((Object)1, (Object)this.remoteCache.stats().getIntStatistic("stores"));
        AssertJUnit.assertEquals((Object)1, (Object)this.remoteCache.stats().getIntStatistic("currentNumberOfEntries"));
        assert (1 == this.remoteCache.size());
        assert (!this.remoteCache.isEmpty());
        AssertJUnit.assertEquals((Object)1, (Object)this.remoteCache.stats().getIntStatistic("totalNumberOfEntries"));
        this.remoteCache.put((Object)"a2", (Object)"v2");
        AssertJUnit.assertEquals((Object)2, (Object)this.remoteCache.stats().getIntStatistic("stores"));
        AssertJUnit.assertEquals((Object)2, (Object)this.remoteCache.stats().getIntStatistic("currentNumberOfEntries"));
        AssertJUnit.assertEquals((Object)2, (Object)this.remoteCache.stats().getIntStatistic("totalNumberOfEntries"));
        assert (2 == this.remoteCache.size());
        assert (!this.remoteCache.isEmpty());
        this.remoteCache.put((Object)"a2", (Object)"v3");
        AssertJUnit.assertEquals((Object)3, (Object)this.remoteCache.stats().getIntStatistic("stores"));
        AssertJUnit.assertEquals((Object)2, (Object)this.remoteCache.stats().getIntStatistic("currentNumberOfEntries"));
        AssertJUnit.assertEquals((Object)3, (Object)this.remoteCache.stats().getIntStatistic("totalNumberOfEntries"));
        assert (2 == this.remoteCache.size());
        assert (!this.remoteCache.isEmpty());
    }

    public void testHitsAndMisses() {
        this.remoteCache.get((Object)"a");
        AssertJUnit.assertEquals((Object)0, (Object)this.remoteCache.stats().getIntStatistic("hits"));
        AssertJUnit.assertEquals((Object)1, (Object)this.remoteCache.stats().getIntStatistic("misses"));
        this.remoteCache.put((Object)"a", (Object)"v");
        AssertJUnit.assertEquals((Object)0, (Object)this.remoteCache.stats().getIntStatistic("hits"));
        AssertJUnit.assertEquals((Object)1, (Object)this.remoteCache.stats().getIntStatistic("misses"));
        this.remoteCache.get((Object)"a");
        AssertJUnit.assertEquals((Object)1, (Object)this.remoteCache.stats().getIntStatistic("hits"));
        AssertJUnit.assertEquals((Object)1, (Object)this.remoteCache.stats().getIntStatistic("misses"));
        this.remoteCache.get((Object)"a");
        this.remoteCache.get((Object)"a");
        this.remoteCache.get((Object)"a");
        AssertJUnit.assertEquals((Object)4, (Object)this.remoteCache.stats().getIntStatistic("hits"));
        AssertJUnit.assertEquals((Object)1, (Object)this.remoteCache.stats().getIntStatistic("misses"));
    }

    public void testRemoveHitsAndMisses() {
        this.remoteCache.remove((Object)"a");
        AssertJUnit.assertEquals((Object)0, (Object)this.remoteCache.stats().getIntStatistic("removeHits"));
        AssertJUnit.assertEquals((Object)1, (Object)this.remoteCache.stats().getIntStatistic("removeMisses"));
        this.remoteCache.put((Object)"a", (Object)"v");
        this.remoteCache.remove((Object)"a");
        AssertJUnit.assertEquals((Object)1, (Object)this.remoteCache.stats().getIntStatistic("removeHits"));
        AssertJUnit.assertEquals((Object)1, (Object)this.remoteCache.stats().getIntStatistic("removeMisses"));
        this.remoteCache.put((Object)"a", (Object)"v");
        this.remoteCache.put((Object)"b", (Object)"v");
        this.remoteCache.put((Object)"c", (Object)"v");
        this.remoteCache.remove((Object)"a");
        this.remoteCache.remove((Object)"b");
        this.remoteCache.remove((Object)"c");
        AssertJUnit.assertEquals((Object)4, (Object)this.remoteCache.stats().getIntStatistic("removeHits"));
        AssertJUnit.assertEquals((Object)1, (Object)this.remoteCache.stats().getIntStatistic("removeMisses"));
    }
}

