/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.util.Properties;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.impl.transport.tcp.TcpTransportFactory;
import org.infinispan.client.hotrod.test.MultiHotRodServersTest;
import org.infinispan.config.Configuration;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.test.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.PingOnStartupTest")
public class PingOnStartupTest
extends MultiHotRodServersTest {
    protected void createCacheManagers() throws Throwable {
        Configuration config = PingOnStartupTest.getDefaultClusteredConfig((Configuration.CacheMode)Configuration.CacheMode.DIST_SYNC);
        this.createHotRodServers(2, config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTopologyFetched() throws Exception {
        Properties props = new Properties();
        HotRodServer hotRodServer2 = this.server(1);
        props.put("infinispan.client.hotrod.server_list", "localhost:" + hotRodServer2.getPort() + ";localhost:" + hotRodServer2.getPort());
        props.put("infinispan.client.hotrod.ping_on_startup", "true");
        props.put("timeBetweenEvictionRunsMillis", "500");
        RemoteCacheManager remoteCacheManager = new RemoteCacheManager(props);
        TcpTransportFactory tcpConnectionFactory = (TcpTransportFactory)TestingUtil.extractField((Object)remoteCacheManager, (String)"transportFactory");
        for (int i = 0; i < 10; ++i) {
            try {
                if (tcpConnectionFactory.getServers().size() != 1) break;
                Thread.sleep(1000L);
                continue;
            }
            finally {
                remoteCacheManager.stop();
            }
        }
        AssertJUnit.assertEquals((int)2, (int)tcpConnectionFactory.getServers().size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTopologyNotFetched() {
        Properties props = new Properties();
        HotRodServer hotRodServer2 = this.server(1);
        props.put("infinispan.client.hotrod.server_list", "localhost:" + hotRodServer2.getPort() + ";localhost:" + hotRodServer2.getPort());
        props.put("infinispan.client.hotrod.ping_on_startup", "false");
        RemoteCacheManager remoteCacheManager = new RemoteCacheManager(props);
        TcpTransportFactory tcpConnectionFactory = (TcpTransportFactory)TestingUtil.extractField((Object)remoteCacheManager, (String)"transportFactory");
        try {
            AssertJUnit.assertEquals((int)1, (int)tcpConnectionFactory.getServers().size());
        }
        finally {
            remoteCacheManager.stop();
        }
    }
}

