/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.protocol;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.client.hotrod.impl.consistenthash.ConsistentHash;
import org.infinispan.client.hotrod.impl.protocol.Codec10;
import org.infinispan.client.hotrod.impl.protocol.HeaderParams;
import org.infinispan.client.hotrod.impl.transport.Transport;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;

public class Codec11
extends Codec10 {
    private static final Log log = LogFactory.getLog(Codec11.class, Log.class);

    @Override
    public HeaderParams writeHeader(Transport transport, HeaderParams params) {
        return this.writeHeader(transport, params, (byte)11);
    }

    @Override
    protected void readNewTopologyAndHash(Transport transport, AtomicInteger topologyId) {
        Log localLog = this.getLog();
        int newTopologyId = transport.readVInt();
        topologyId.set(newTopologyId);
        int numKeyOwners = transport.readUnsignedShort();
        short hashFctVersion = transport.readByte();
        ConsistentHash ch = null;
        if (hashFctVersion != 0) {
            ch = transport.getTransportFactory().getConsistentHashFactory().newConsistentHash(hashFctVersion);
        } else {
            localLog.trace("Not using a consistent hash function (hash function version == 0)");
        }
        int hashSpace = transport.readVInt();
        int clusterSize = transport.readVInt();
        int numVirtualNodes = transport.readVInt();
        localLog.tracef("Topology change request: newTopologyId=%d, numKeyOwners=%d, hashFunctionVersion=%d, hashSpaceSize=%d, clusterSize=%d, numVirtualNodes=%d", new Object[]{newTopologyId, numKeyOwners, hashFctVersion, hashSpace, clusterSize, numVirtualNodes});
        LinkedHashMap<SocketAddress, Set<Integer>> servers2Hash = new LinkedHashMap<SocketAddress, Set<Integer>>();
        for (int i = 0; i < clusterSize; ++i) {
            String host = transport.readString();
            int port = transport.readUnsignedShort();
            int baseHashCode = transport.read4ByteInt();
            int normalizedHashCode = this.getNormalizedHash(baseHashCode, ch);
            localLog.tracef("Server(%s:%d) read with base hash code %d, and normalized hash code %d", new Object[]{host, port, baseHashCode, normalizedHashCode});
            this.cacheHashCode(servers2Hash, host, port, normalizedHashCode);
            if (numVirtualNodes <= 1) continue;
            this.calcVirtualHashCodes(baseHashCode, numVirtualNodes, servers2Hash, host, port, ch);
        }
        if (localLog.isInfoEnabled()) {
            localLog.newTopology(servers2Hash.keySet());
        }
        transport.getTransportFactory().updateServers(servers2Hash.keySet());
        if (hashFctVersion == 0) {
            localLog.trace("Not using a consistent hash function (hash function version == 0)");
        } else {
            transport.getTransportFactory().updateHashFunction(servers2Hash, numKeyOwners, hashFctVersion, hashSpace);
        }
    }

    @Override
    public Log getLog() {
        return log;
    }

    private int getNormalizedHash(int baseHashCode, ConsistentHash ch) {
        if (ch != null) {
            return ch.getNormalizedHash(baseHashCode);
        }
        return baseHashCode;
    }

    private void calcVirtualHashCodes(int addrHashCode, int numVirtualNodes, Map<SocketAddress, Set<Integer>> servers2Hash, String host, int port, ConsistentHash ch) {
        for (int j = 1; j < numVirtualNodes; ++j) {
            int hashCode = this.calcVNodeHashCode(addrHashCode, j);
            this.cacheHashCode(servers2Hash, host, port, this.getNormalizedHash(hashCode, ch));
        }
    }

    private void cacheHashCode(Map<SocketAddress, Set<Integer>> servers2Hash, String host, int port, int hashCode) {
        InetSocketAddress address = new InetSocketAddress(host, port);
        Set<Integer> hashes = servers2Hash.get(address);
        if (hashes == null) {
            hashes = new HashSet<Integer>();
            servers2Hash.put(address, hashes);
        }
        hashes.add(hashCode);
        this.getLog().tracef("Hash code is: %d", hashCode);
    }

    private int calcVNodeHashCode(int addrHashCode, int id) {
        int result = id;
        result = 31 * result + addrHashCode;
        return result;
    }
}

