/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.util.HashMap;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.TestHelper;
import org.infinispan.client.hotrod.exceptions.RemoteCacheManagerNotStartedException;
import org.infinispan.config.Configuration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.AfterTest;
import org.testng.annotations.Test;

@Test(testName="client.hotrod.CacheManagerStoppedTest", groups={"functional"})
public class CacheManagerStoppedTest
extends SingleCacheManagerTest {
    private static final String CACHE_NAME = "someName";
    EmbeddedCacheManager cacheManager = null;
    HotRodServer hotrodServer = null;
    RemoteCacheManager remoteCacheManager;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        this.cacheManager = TestCacheManagerFactory.createLocalCacheManager((boolean)false);
        this.cacheManager.defineConfiguration(CACHE_NAME, new Configuration());
        this.hotrodServer = TestHelper.startHotRodServer(this.cacheManager);
        this.remoteCacheManager = new RemoteCacheManager("localhost:" + this.hotrodServer.getPort(), true);
        return this.cacheManager;
    }

    @AfterTest(alwaysRun=true)
    public void release() {
        if (this.cacheManager != null) {
            this.cacheManager.stop();
        }
        if (this.hotrodServer != null) {
            this.hotrodServer.stop();
        }
    }

    public void testGetCacheOperations() {
        assert (this.remoteCacheManager.getCache() != null);
        assert (this.remoteCacheManager.getCache(CACHE_NAME) != null);
        this.cache().put((Object)"k", (Object)"v");
        assert (this.cache().get((Object)"k").equals("v"));
    }

    @Test(dependsOnMethods={"testGetCacheOperations"})
    public void testStopCacheManager() {
        assert (this.remoteCacheManager.isStarted());
        this.remoteCacheManager.stop();
        assert (!this.remoteCacheManager.isStarted());
        assert (this.remoteCacheManager.getCache() != null);
        assert (this.remoteCacheManager.getCache(CACHE_NAME) != null);
    }

    @Test(expectedExceptions={RemoteCacheManagerNotStartedException.class}, dependsOnMethods={"testStopCacheManager"})
    public void testGetCacheOperations2() {
        this.remoteCacheManager.getCache().put((Object)"k", (Object)"v");
    }

    @Test(expectedExceptions={RemoteCacheManagerNotStartedException.class}, dependsOnMethods={"testStopCacheManager"})
    public void testGetCacheOperations3() {
        this.remoteCacheManager.getCache(CACHE_NAME).put((Object)"k", (Object)"v");
    }

    @Test(expectedExceptions={RemoteCacheManagerNotStartedException.class}, dependsOnMethods={"testStopCacheManager"})
    public void testPut() {
        this.cache().put((Object)"k", (Object)"v");
    }

    @Test(expectedExceptions={RemoteCacheManagerNotStartedException.class}, dependsOnMethods={"testStopCacheManager"})
    public void testPutAsync() {
        this.cache().putAsync((Object)"k", (Object)"v");
    }

    @Test(expectedExceptions={RemoteCacheManagerNotStartedException.class}, dependsOnMethods={"testStopCacheManager"})
    public void testGet() {
        this.cache().get((Object)"k");
    }

    @Test(expectedExceptions={RemoteCacheManagerNotStartedException.class}, dependsOnMethods={"testStopCacheManager"})
    public void testReplace() {
        this.cache().replace((Object)"k", (Object)"v");
    }

    @Test(expectedExceptions={RemoteCacheManagerNotStartedException.class}, dependsOnMethods={"testStopCacheManager"})
    public void testReplaceAsync() {
        this.cache().replaceAsync((Object)"k", (Object)"v");
    }

    @Test(expectedExceptions={RemoteCacheManagerNotStartedException.class}, dependsOnMethods={"testStopCacheManager"})
    public void testPutAll() {
        this.cache().putAll(new HashMap());
    }

    @Test(expectedExceptions={RemoteCacheManagerNotStartedException.class}, dependsOnMethods={"testStopCacheManager"})
    public void testPutAllAsync() {
        this.cache().putAllAsync(new HashMap());
    }

    @Test(expectedExceptions={RemoteCacheManagerNotStartedException.class}, dependsOnMethods={"testStopCacheManager"})
    public void testVersionedGet() {
        this.cache().getVersioned((Object)"key");
    }

    @Test(expectedExceptions={RemoteCacheManagerNotStartedException.class}, dependsOnMethods={"testStopCacheManager"})
    public void testVersionedRemove() {
        this.cache().removeWithVersion((Object)"key", 12312321L);
    }

    @Test(expectedExceptions={RemoteCacheManagerNotStartedException.class}, dependsOnMethods={"testStopCacheManager"})
    public void testVersionedRemoveAsync() {
        this.cache().removeWithVersionAsync((Object)"key", 12312321L);
    }

    private RemoteCache<Object, Object> cache() {
        return this.remoteCacheManager.getCache();
    }
}

