/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.test;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.TestHelper;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.config.Configuration;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;

public abstract class MultiHotRodServersTest
extends MultipleCacheManagersTest {
    protected List<HotRodServer> servers = new ArrayList<HotRodServer>();
    protected List<RemoteCacheManager> clients = new ArrayList<RemoteCacheManager>();

    protected void createHotRodServers(int num, Configuration defaultCfg) {
        int i;
        for (i = 0; i < num; ++i) {
            this.addHotRodServer(defaultCfg);
        }
        for (i = 0; i < num; ++i) {
            assert (this.manager(i).getCache() != null);
        }
        TestingUtil.blockUntilViewReceived((Cache)this.manager(0).getCache(), (int)num, (long)10000L);
        for (i = 0; i < num; ++i) {
            TestingUtil.blockUntilCacheStatusAchieved((Cache)this.manager(i).getCache(), (ComponentStatus)ComponentStatus.RUNNING, (long)10000L);
        }
        if (defaultCfg.getCacheMode().isSynchronous()) {
            this.cache(0).put((Object)"k", (Object)"v");
            for (i = 0; i < num; ++i) {
                AssertJUnit.assertEquals((Object)"v", (Object)this.cache(i).get((Object)"k"));
            }
        } else {
            for (i = 1; i < num; ++i) {
                this.replListener(this.cache(i)).expect(new Class[]{PutKeyValueCommand.class});
            }
            this.cache(0).put((Object)"k", (Object)"v");
            for (i = 1; i < num; ++i) {
                this.replListener(this.cache(i)).waitForRpc();
                AssertJUnit.assertEquals((Object)"v", (Object)this.cache(i).get((Object)"k"));
            }
        }
        for (i = 0; i < num; ++i) {
            Properties props = new Properties();
            props.put("infinispan.client.hotrod.server_list", String.format("localhost:%d", this.server(i).getPort()));
            props.put("infinispan.client.hotrod.ping_on_startup", "false");
            this.clients.add(new RemoteCacheManager(props));
        }
    }

    @AfterMethod(alwaysRun=true)
    protected void clearContent() throws Throwable {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AfterClass(alwaysRun=true)
    protected void destroy() {
        try {
            for (HotRodServer server : this.servers) {
                server.stop();
            }
        }
        finally {
            super.destroy();
        }
    }

    private HotRodServer addHotRodServer(Configuration cfg) {
        EmbeddedCacheManager cm = this.addClusterEnabledCacheManager(cfg);
        HotRodServer server = TestHelper.startHotRodServer(cm);
        this.servers.add(server);
        return server;
    }

    protected HotRodServer server(int i) {
        return this.servers.get(i);
    }

    protected RemoteCacheManager client(int i) {
        return this.clients.get(i);
    }
}

